/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.templates.json;

import com.pugh.sockso.Utils;
import com.pugh.sockso.templates.json.TResultSet;
import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;

public class TResultSetImpl
extends AbstractTemplateImpl
implements TResultSet.Intf {
    private final ResultSet resultSet;

    protected static TResultSet.ImplData __jamon_setOptionalArguments(TResultSet.ImplData p_implData) {
        if (!p_implData.getResultSet__IsNotDefault()) {
            p_implData.setResultSet(null);
        }
        return p_implData;
    }

    public TResultSetImpl(TemplateManager p_templateManager, TResultSet.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TResultSetImpl.__jamon_setOptionalArguments(p_implData));
        this.resultSet = p_implData.getResultSet();
    }

    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("[\r\n");
        boolean isFirst = true;
        try {
            while (this.resultSet.next()) {
                if (!isFirst) {
                    jamonWriter.write(",\n");
                } else {
                    isFirst = false;
                }
                jamonWriter.write("{");
                ResultSetMetaData metadata = this.resultSet.getMetaData();
                int columnCount = metadata.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    String columnName = metadata.getColumnName(i + 1);
                    String columnValue = this.resultSet.getString(columnName);
                    if (i > 0) {
                        jamonWriter.write(",");
                    }
                    if (columnValue == null) {
                        columnValue = "";
                    }
                    jamonWriter.write("'" + Utils.escapeJs(columnName) + "': '" + Utils.escapeJs(columnValue) + "'");
                }
                jamonWriter.write("}");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        jamonWriter.write("]");
    }
}

