/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.tag;

import com.pugh.sockso.music.tag.AudioTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.VorbisComment;

public class FlacTag
extends AudioTag {
    private static final Logger log = Logger.getLogger(FlacTag.class);

    public void parse(File file) throws IOException {
        Metadata[] metadata;
        FileInputStream in = new FileInputStream(file);
        FLACDecoder dec = new FLACDecoder((InputStream)in);
        for (Metadata item : metadata = dec.readMetadata(dec.readStreamInfo())) {
            if (!item.getClass().equals(VorbisComment.class)) continue;
            VorbisComment comment = (VorbisComment)item;
            this.artistTitle = this.getComment(comment, "ARTIST");
            this.albumTitle = this.getComment(comment, "ALBUM");
            this.trackTitle = this.getComment(comment, "TITLE");
            this.albumYear = this.getComment(comment, "DATE");
            this.setTrackNumber(this.getComment(comment, "TRACKNUMBER"));
        }
    }

    protected String getComment(VorbisComment comment, String name) {
        try {
            String[] comments = comment.getCommentByName(name);
            return comments.length > 0 ? comments[0] : "";
        }
        catch (Exception e) {
            return name;
        }
    }
}

