/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.music.CollectionManagerListener;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.music.indexing.IndexEvent;
import com.pugh.sockso.music.indexing.IndexListener;
import com.pugh.sockso.music.indexing.Indexer;
import com.pugh.sockso.music.tag.AudioTag;
import com.pugh.sockso.music.tag.InvalidTagException;
import com.pugh.sockso.music.tag.Tag;
import com.pugh.sockso.web.User;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DBCollectionManager
extends Thread
implements CollectionManager,
IndexListener {
    private static final Logger log = Logger.getLogger(CollectionManager.class);
    private final Database db;
    private final Properties p;
    private final Vector<CollectionManagerListener> listeners;
    private final Indexer indexer;

    public DBCollectionManager(Database db, Properties p, Indexer indexer) {
        this.db = db;
        this.p = p;
        this.indexer = indexer;
        this.listeners = new Vector();
    }

    public void indexChanged(IndexEvent evt) {
        try {
            switch (evt.getType()) {
                case 1: {
                    this.addFile(evt.getFileId(), evt.getFile());
                    break;
                }
                case 3: {
                    this.checkTrack(this.getTrack(evt.getFileId()), evt.getFile());
                    break;
                }
                case 2: {
                    this.removeTrack(evt.getFileId());
                    break;
                }
                case 4: {
                    this.removeEmptyArtistsAndAlbums();
                    this.fireCollectionManagerEvent(6, "Collection Updated!");
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Track getTrack(int trackId) throws SQLException {
        Track track;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = Track.getSelectFromSql() + " where t.id = ? ";
            st = this.db.prepare(sql);
            st.setInt(1, trackId);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Invalid track id");
            }
            track = Track.createFromResultSet(rs);
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return track;
    }

    protected void addFile(int collectionId, File file) throws InvalidTagException, IOException {
        Tag tag = AudioTag.getTag(file);
        log.debug((Object)(tag.getArtist() + " - " + tag.getAlbum() + " - " + tag.getAlbumYear() + " - " + tag.getTrack()));
        int artistId = this.addArtist(tag.getArtist());
        int albumId = this.addAlbum(artistId, tag.getAlbum(), tag.getAlbumYear());
        this.addTrack(artistId, albumId, tag.getTrack(), tag.getTrackNumber(), file, collectionId);
    }

    public void scanDirectory(int collectionId, File directory) {
        try {
            this.indexer.scanDirectory(collectionId, directory);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void checkCollection() {
        this.indexer.scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAlbumTagInfo(int artistId, Tag tag, Track track) throws SQLException {
        if (!track.getAlbum().getName().toLowerCase().equals(tag.getAlbum().toLowerCase()) || !track.getAlbum().getYear().toLowerCase().equals(tag.getAlbumYear().toLowerCase())) {
            ResultSet rs = null;
            PreparedStatement st = null;
            try {
                String sql = " select id  from albums  where name = ?  and artist_id = ? ";
                st = this.db.prepare(sql);
                st.setString(1, tag.getAlbum());
                st.setInt(2, artistId);
                rs = st.executeQuery();
                int newAlbumId = rs.next() ? rs.getInt("id") : this.addAlbum(artistId, tag.getAlbum(), tag.getAlbumYear());
                Utils.close(rs);
                Utils.close(st);
                sql = " update tracks  set album_id = ?  where id = ? ";
                st = this.db.prepare(sql);
                st.setInt(1, newAlbumId);
                st.setInt(2, track.getId());
                st.execute();
                Utils.close(rs);
                Utils.close(st);
                sql = " update albums  set year = ?  where id = ? ";
                st = this.db.prepare(sql);
                st.setString(1, tag.getAlbumYear());
                st.setInt(2, newAlbumId);
                st.execute();
            }
            catch (Throwable throwable) {
                Utils.close(rs);
                Utils.close(st);
                throw throwable;
            }
            Utils.close(rs);
            Utils.close(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int checkArtistTagInfo(Tag tag, Track track) throws SQLException {
        if (!track.getArtist().getName().toLowerCase().equals(tag.getArtist().toLowerCase())) {
            int n;
            PreparedStatement st = null;
            ResultSet rs = null;
            try {
                String sql = " select id  from artists  where name = ? ";
                st = this.db.prepare(sql);
                st.setString(1, tag.getArtist());
                rs = st.executeQuery();
                int newArtistId = rs.next() ? rs.getInt("id") : this.addArtist(tag.getArtist());
                Utils.close(rs);
                Utils.close(st);
                sql = " update tracks  set artist_id = ?  where id = ? ";
                st = this.db.prepare(sql);
                st.setInt(1, newArtistId);
                st.setInt(2, track.getId());
                st.execute();
                n = newArtistId;
            }
            catch (Throwable throwable) {
                Utils.close(rs);
                Utils.close(st);
                throw throwable;
            }
            Utils.close(rs);
            Utils.close(st);
            return n;
        }
        this.updateArtistBrowseName(track.getArtist().getId(), tag.getArtist());
        return track.getArtist().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateArtistBrowseName(int artistId, String realName) throws SQLException {
        PreparedStatement st = null;
        try {
            String browseName = this.getArtistBrowseName(this.getArtistPrefixesToRemove(), realName);
            String sql = " update artists  set browse_name = ?  where id = ? ";
            st = this.db.prepare(" update artists  set browse_name = ?  where id = ? ");
            st.setString(1, browseName);
            st.setInt(2, artistId);
            st.execute();
        }
        catch (Throwable throwable) {
            Utils.close(st);
            throw throwable;
        }
        Utils.close(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTrackTagInfo(Tag tag, Track track) throws SQLException {
        if (!track.getName().equals(tag.getTrack()) || track.getNumber() != tag.getTrackNumber()) {
            PreparedStatement st = null;
            try {
                String sql = " update tracks  set name = ?,  track_no = ?  where id = ? ";
                st = this.db.prepare(" update tracks  set name = ?,  track_no = ?  where id = ? ");
                st.setString(1, tag.getTrack());
                st.setInt(2, tag.getTrackNumber());
                st.setInt(3, track.getId());
                st.execute();
            }
            catch (Throwable throwable) {
                Utils.close(st);
                throw throwable;
            }
            Utils.close(st);
        }
    }

    private void checkTrack(Track track, File file) {
        try {
            Tag tag = AudioTag.getTag(file);
            this.checkTrackTagInfo(tag, track);
            int artistId = this.checkArtistTagInfo(tag, track);
            this.checkAlbumTagInfo(artistId, tag, track);
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
        catch (InvalidTagException e) {
            log.debug((Object)e);
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    protected String getArtistBrowseName(String[] prefixes, String name) {
        for (String prefix : prefixes) {
            if (!name.substring(0, prefix.length()).toLowerCase().equals(prefix.toLowerCase())) continue;
            return name.substring(prefix.length());
        }
        return name;
    }

    protected String[] getArtistPrefixesToRemove() {
        return this.p.get("collman.artists.removePrefixes").split(",");
    }

    protected void removeTrack(int trackId) throws SQLException {
        String sql = "";
        sql = " delete from play_log  where track_id = '" + trackId + "' ";
        this.db.update(sql);
        sql = " delete from playlist_tracks  where track_id = '" + trackId + "' ";
        this.db.update(sql);
        sql = " delete from tracks  where id = '" + trackId + "' ";
        this.db.update(sql);
    }

    public void addCollectionManagerListener(CollectionManagerListener listener) {
        this.listeners.add(listener);
    }

    public void fireCollectionManagerEvent(int type, String message) {
        for (CollectionManagerListener listener : this.listeners) {
            listener.collectionManagerChangePerformed(type, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addDirectoryToDb(File dir) throws SQLException, SQLException {
        int n;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            String sql = " insert into collection ( path )  values ( ? ) ";
            st = this.db.prepare(sql);
            st.setString(1, Utils.getPathWithSlash(dir));
            st.execute();
            Utils.close(st);
            sql = " select max(c.id) as new_id  from collection c ";
            st = this.db.prepare(sql);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new SQLException("unable to retrieve new id");
            }
            n = rs.getInt("new_id");
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return n;
    }

    public int addDirectory(File dir) {
        try {
            int collectionId = this.addDirectoryToDb(dir);
            this.indexer.scanDirectory(collectionId, dir);
            this.removeEmptyArtistsAndAlbums();
            this.fireCollectionManagerEvent(6, "Update Finished");
            return collectionId;
        }
        catch (Exception e) {
            log.error((Object)("Error adding folder to collection: " + e.getMessage()));
            this.fireCollectionManagerEvent(0, e.getMessage());
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int addArtist(String name) {
        PreparedStatement st;
        ResultSet rs;
        block9: {
            if (name.equals("")) {
                name = "Unknown Artist";
            }
            rs = null;
            st = null;
            try {
                try {
                    String browseName = this.getArtistBrowseName(this.getArtistPrefixesToRemove(), name);
                    st = this.db.prepare(" insert into artists ( name, date_added, browse_name )  values ( ?, current_timestamp, ? ) ");
                    st.setString(1, name);
                    st.setString(2, browseName);
                    st.execute();
                    log.debug((Object)("Added Artist: " + name));
                }
                catch (Exception e) {
                    Utils.close(st);
                    catch (Throwable throwable) {
                        Utils.close(st);
                        throw throwable;
                    }
                }
                Utils.close(st);
                st = this.db.prepare(" select id  from artists  where name = ? ");
                st.setString(1, name);
                rs = st.executeQuery();
                if (!rs.next()) break block9;
                this.fireCollectionManagerEvent(1, name);
                int e = rs.getInt("id");
            }
            catch (Exception e) {
                try {
                    log.error((Object)("Error Adding Artist: " + e));
                }
                catch (Throwable throwable) {
                    Utils.close(rs);
                    Utils.close(st);
                    System.gc();
                    throw throwable;
                }
                Utils.close(rs);
                Utils.close(st);
                System.gc();
            }
            Utils.close(rs);
            Utils.close(st);
            System.gc();
            return e;
        }
        Utils.close(rs);
        Utils.close(st);
        System.gc();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int addAlbum(int artistId, String name, String year) {
        PreparedStatement st;
        ResultSet rs;
        block13: {
            int n;
            block12: {
                if (name.equals("")) {
                    name = "Unknown Album";
                }
                rs = null;
                st = null;
                try {
                    block11: {
                        try {
                            st = this.db.prepare(" insert into albums ( artist_id, name, year, date_added )  values ( ?, ?, ?, current_timestamp ) ");
                            st.setInt(1, artistId);
                            st.setString(2, name);
                            st.setString(3, year);
                            st.execute();
                            log.debug((Object)("Added Album: " + name + " " + year));
                        }
                        catch (Exception e) {
                            Utils.close(st);
                            break block11;
                            catch (Throwable throwable) {
                                Utils.close(st);
                                throw throwable;
                            }
                        }
                        Utils.close(st);
                    }
                    String sql = " select id  from albums  where artist_id = ?  and name = ? ";
                    st = this.db.prepare(" select id  from albums  where artist_id = ?  and name = ? ");
                    st.setInt(1, artistId);
                    st.setString(2, name);
                    rs = st.executeQuery();
                    if (rs.next()) {
                        this.fireCollectionManagerEvent(2, name);
                        n = rs.getInt("id");
                        Utils.close(rs);
                        break block12;
                    }
                    Utils.close(rs);
                    break block13;
                }
                catch (Exception e) {
                    log.error((Object)("Error Adding Album (" + name + "): " + e.getMessage()));
                    return -1;
                }
            }
            Utils.close(st);
            return n;
        }
        Utils.close(st);
        return -1;
        finally {
            Utils.close(rs);
            Utils.close(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int addTrack(int artistId, int albumId, String name, int trackNo, File file, int collectionId) {
        PreparedStatement st;
        ResultSet rs;
        block9: {
            int n;
            if (name.equals("")) {
                name = "Unknown Track (" + trackNo + ")";
            }
            rs = null;
            st = null;
            try {
                String sql;
                try {
                    sql = " insert into tracks ( artist_id, album_id, name, path,  length, collection_id, date_added, track_no )  values ( ?, ?, ?, ?, 100, ?, current_timestamp, ? ) ";
                    st = this.db.prepare(" insert into tracks ( artist_id, album_id, name, path,  length, collection_id, date_added, track_no )  values ( ?, ?, ?, ?, 100, ?, current_timestamp, ? ) ");
                    st.setInt(1, artistId);
                    st.setInt(2, albumId);
                    st.setString(3, name);
                    st.setString(4, file.getAbsolutePath());
                    st.setInt(5, collectionId);
                    st.setInt(6, trackNo);
                    st.execute();
                    log.debug((Object)("Added Track: " + name));
                }
                catch (Exception e) {
                    Utils.close(st);
                    catch (Throwable throwable) {
                        Utils.close(st);
                        throw throwable;
                    }
                }
                Utils.close(st);
                sql = " select id  from tracks  where artist_id = ?  and album_id = ?  and name = ? ";
                st = this.db.prepare(" select id  from tracks  where artist_id = ?  and album_id = ?  and name = ? ");
                st.setInt(1, artistId);
                st.setInt(2, albumId);
                st.setString(3, name);
                rs = st.executeQuery();
                if (!rs.next()) break block9;
                this.fireCollectionManagerEvent(3, name);
                n = rs.getInt("id");
            }
            catch (Exception e) {
                try {
                    log.error((Object)("Error Adding Track: " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    Utils.close(rs);
                    Utils.close(st);
                    throw throwable;
                }
                Utils.close(rs);
                Utils.close(st);
            }
            Utils.close(rs);
            Utils.close(st);
            return n;
        }
        Utils.close(rs);
        Utils.close(st);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDirectory(String path) {
        PreparedStatement st;
        ResultSet rs;
        block4: {
            boolean bl;
            rs = null;
            st = null;
            try {
                String sql = " select id  from collection c  where path = ? ";
                st = this.db.prepare(sql);
                st.setString(1, Utils.getPathWithSlash(path));
                rs = st.executeQuery();
                if (!rs.next()) break block4;
                int collectionId = rs.getInt("id");
                Utils.close(rs);
                Utils.close(st);
                sql = " delete from play_log  where track_id in (  select id  from tracks t  where collection_id = ?  ) ";
                st = this.db.prepare(sql);
                st.setInt(1, collectionId);
                st.execute();
                Utils.close(st);
                sql = " delete from playlist_tracks  where track_id in ( select id  from tracks  where collection_id = ? ) ";
                st = this.db.prepare(sql);
                st.setInt(1, collectionId);
                st.execute();
                Utils.close(st);
                sql = " delete from tracks  where collection_id = ? ";
                st = this.db.prepare(sql);
                st.setInt(1, collectionId);
                st.execute();
                Utils.close(st);
                sql = " delete from collection  where id = ? ";
                st = this.db.prepare(sql);
                st.setInt(1, collectionId);
                st.execute();
                Utils.close(st);
                this.removeEmptyArtistsAndAlbums();
                this.fireCollectionManagerEvent(6, "Directory Removed");
                bl = true;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    Utils.close(rs);
                    Utils.close(st);
                    throw throwable;
                }
                Utils.close(rs);
                Utils.close(st);
            }
            Utils.close(rs);
            Utils.close(st);
            return bl;
        }
        Utils.close(rs);
        Utils.close(st);
        return false;
    }

    protected void removeEmptyArtistsAndAlbums() throws SQLException {
        String sql = null;
        sql = " delete from artists  where id not in ( select artist_id  from tracks ) ";
        this.db.update(sql);
        sql = " delete from albums  where id not in ( select album_id  from tracks ) ";
        this.db.update(sql);
    }

    public int savePlaylist(String name, Track[] tracks) {
        return this.savePlaylist(name, tracks, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int savePlaylist(String name, Track[] tracks, User user) {
        int n;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            int playlistId = -1;
            String sql = " select id  from playlists p  where name = ? ";
            st = this.db.prepare(sql);
            st.setString(1, name);
            rs = st.executeQuery();
            if (rs.next()) {
                this.removePlaylist(rs.getInt("id"));
            }
            Utils.close(rs);
            Utils.close(st);
            sql = " insert into playlists ( name, user_id, date_created, date_modified )  values ( ?, ?, current_timestamp, current_timestamp ) ";
            st = this.db.prepare(sql);
            st.setString(1, name);
            if (user == null) {
                st.setNull(2, 4);
            } else {
                st.setInt(2, user.getId());
            }
            st.execute();
            Utils.close(rs);
            Utils.close(st);
            sql = " select max(p.id) as new_id  from playlists p ";
            st = this.db.prepare(sql);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new SQLException("couldn't get new playlist id");
            }
            playlistId = rs.getInt("new_id");
            Utils.close(rs);
            Utils.close(st);
            sql = " insert into playlist_tracks ( playlist_id, track_id )  values ( ?, ? ) ";
            st = this.db.prepare(sql);
            for (Track track : tracks) {
                st.setInt(1, playlistId);
                st.setInt(2, track.getId());
                st.execute();
            }
            this.fireCollectionManagerEvent(4, name);
            n = playlistId;
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage());
            }
            catch (Throwable throwable) {
                Utils.close(rs);
                Utils.close(st);
                throw throwable;
            }
            Utils.close(rs);
            Utils.close(st);
            return -1;
        }
        Utils.close(rs);
        Utils.close(st);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePlaylist(int id) {
        PreparedStatement st = null;
        try {
            String sql = " delete from playlist_tracks  where playlist_id = ? ";
            st = this.db.prepare(sql);
            st.setInt(1, id);
            st.execute();
            Utils.close(st);
            sql = " delete from playlists  where id = ? ";
            st = this.db.prepare(sql);
            st.setInt(1, id);
            st.execute();
            this.fireCollectionManagerEvent(4, "Playlist removed");
        }
        catch (SQLException e) {
            boolean bl;
            try {
                log.error((Object)e);
                bl = false;
            }
            catch (Throwable throwable) {
                Utils.close(st);
                throw throwable;
            }
            Utils.close(st);
            return bl;
        }
        Utils.close(st);
        return true;
    }
}

