/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.gui.AppFrame;
import com.pugh.sockso.resources.Resources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdesktop.jdic.tray.SystemTray;
import snoozesoft.systray4j.SysTrayMenu;
import snoozesoft.systray4j.SysTrayMenuEvent;
import snoozesoft.systray4j.SysTrayMenuIcon;
import snoozesoft.systray4j.SysTrayMenuListener;

public class TrayIcon
implements ActionListener,
SysTrayMenuListener {
    private static Logger log = Logger.getLogger(TrayIcon.class);
    private final AppFrame af;
    private final Resources r;
    private org.jdesktop.jdic.tray.TrayIcon allTray;
    private SysTrayMenuIcon winTray = null;
    private boolean isActive = false;

    public TrayIcon(AppFrame af, Resources r) {
        this.af = af;
        this.r = r;
    }

    public void init() {
        try {
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
                log.info((Object)"Creating Windows Tray Icon");
                this.winTray = new SysTrayMenuIcon("icons/tray");
                this.winTray.addSysTrayMenuListener((SysTrayMenuListener)this);
                new SysTrayMenu(this.winTray, "Sockso");
            } else {
                log.info((Object)"Creating JDIC Tray Icon");
                ImageIcon icon = new ImageIcon(this.r.getImage("icons/tray.png"));
                this.allTray = new org.jdesktop.jdic.tray.TrayIcon((Icon)icon, "Sockso", null);
                this.allTray.addActionListener((ActionListener)this);
                SystemTray.getDefaultSystemTray().addTrayIcon(this.allTray);
            }
            this.isActive = true;
        }
        catch (NoClassDefFoundError e) {
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void actionPerformed(ActionEvent evt) {
        this.trayIconClicked();
    }

    private void trayIconClicked() {
        this.af.toggleVisibility();
    }

    public void iconLeftClicked(SysTrayMenuEvent evt) {
        this.trayIconClicked();
    }

    public void iconLeftDoubleClicked(SysTrayMenuEvent e) {
    }

    public void menuItemSelected(SysTrayMenuEvent e) {
    }
}

