/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.db;

import com.pugh.sockso.db.DatabaseConnectionException;
import com.pugh.sockso.db.JDBCDatabase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import joptsimple.OptionSet;
import org.apache.log4j.Logger;

public class SQLiteDatabase
extends JDBCDatabase {
    private static final Logger log = Logger.getLogger(SQLiteDatabase.class);
    private Connection cnn;

    public void connect(OptionSet options) throws DatabaseConnectionException {
        try {
            Class.forName("org.sqlite.JDBC");
            this.cnn = DriverManager.getConnection("jdbc:sqlite:" + SQLiteDatabase.getDefaultDatabasePath(".sqlite"));
            this.createStructure();
            this.checkUserIsActiveColumnExists();
        }
        catch (Exception e) {
            throw new DatabaseConnectionException(e.getMessage());
        }
    }

    protected void createStructure() {
        String sql = "";
        try {
            sql = " create table tracks (  id integer not null primary key autoincrement,  artist_id integer not null,  album_id integer null,  name text not null,  path text not null,  length integer not null,  date_added datetime not null,  collection_id integer not null,  track_no integer null,  unique ( artist_id, album_id, name )  ) ";
            this.update(sql);
            sql = " create table play_log (  id integer not null primary key autoincrement,  track_id integer null,  date_played datetime not null,  user_id integer null,  scrobbled integer not null default 0  ) ";
            this.update(sql);
            sql = " create table playlist_tracks (  id integer not null primary key autoincrement,  playlist_id integer null,  track_id integer null  ) ";
            this.update(sql);
            sql = " create table playlists (  id integer not null primary key autoincrement,  name text not null,  date_created datetime not null,  date_modified datetime not null,  user_id integer null,  unique ( name )  ) ";
            this.update(sql);
            sql = " create table collection (  id integer not null primary key autoincrement,  path text not null,  unique ( path )  ) ";
            this.update(sql);
            sql = " create table artists (  id integer not null primary key autoincrement,  name text not null,  date_added datetime not null,  unique ( name )  ) ";
            this.update(sql);
            sql = " create table albums (  id integer not null primary key autoincrement,  artist_id integer not null,  name text not null,  year text null,  date_added datetime not null,  unique ( artist_id, name )  ) ";
            this.update(sql);
            sql = " create table request_log (  id integer not null primary key autoincrement,  user_id integer null,  ip_address text not null,  date_of_request datetime not null,  request_url text not null,  user_agent text not null,  referer text not null,  cookies text not null  ) ";
            this.update(sql);
            sql = " create table sessions (  id integer not null primary key autoincrement,  code text not null,  user_id integer not null,  date_created datetime not null  ) ";
            this.update(sql);
            sql = " create table users (  id integer not null primary key autoincrement, name text not null unique,  pass text not null,  email text not null, date_created datetime not null,  is_admin integer not null default '0'  ) ";
            this.update(sql);
            sql = " create table properties (  id integer not null primary key autoincrement,  name text not null,  value text not null, unique ( name )  ) ";
            this.update(sql);
            sql = " create index ix_play_log_track_id  on play_log ( track_id ) ";
            this.update(sql);
            this.setDefaultProperties();
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
    }

    public Connection getConnection() {
        return this.cnn;
    }

    public String escape(String str) {
        return str.replaceAll("'", "''");
    }

    public void close() {
        try {
            this.cnn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getRandomFunction() {
        return "random";
    }
}

