#	OpenShot Video Editor is a program that creates, modifies, and edits video files.
#   Copyright (C) 2010  Jonathan Thomas
#
#	This file is part of OpenShot Video Editor (http://launchpad.net/openshot/).
#
#	OpenShot Video Editor is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	OpenShot Video Editor is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with OpenShot Video Editor.  If not, see <http://www.gnu.org/licenses/>.

import os
import gtk
from windows.SimpleGtkBuilderApp import SimpleGtkBuilderApp
from windows import preferences
from classes import project, messagebox

# init the foreign language
from language import Language_Init


class frmAddToTimeline(SimpleGtkBuilderApp):

	def __init__(self, path="AddToTimeline.ui", root="frmAddToTimeline", domain="OpenShot", form=None, project=None, **kwargs):
		SimpleGtkBuilderApp.__init__(self, os.path.join(project.UI_DIR, path), root, domain, **kwargs)

		# Add language support
		_ = Language_Init.Translator(project).lang.gettext

		self.form = form
		self.project = project
		self.frmAddToTimeline.show_all()


	def on_btnAdd_clicked(self, widget, *args):
		print "on_btnAdd_clicked"
		self.frmAddToTimeline.destroy()
		
	def on_btnCancel_clicked(self, widget, *args):
		print "on_btnCancel_clicked"
		self.frmAddToTimeline.destroy()
		
		
	def on_btnMoveUp_clicked(self, widget, *args):
		print "on_btnMoveUp_clicked"
		
	def on_btnMoveDown_clicked(self, widget, *args):
		print "on_btnMoveDown_clicked"
		
	def on_btnShuffle_clicked(self, widget, *args):
		print "on_btnShuffle_clicked"
		
	def on_btnRemove_clicked(self, widget, *args):
		print "on_btnRemove_clicked"
		

		
			
def main():
	frm_add_files = frmAddToTimeline()
	frm_add_files.run()

if __name__ == "__main__":
	main()
