/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeList<E>
extends AbstractList<E> {
    private AVLNode<E> root;
    private int size;

    public TreeList() {
    }

    public TreeList(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    @Override
    public E get(int n) {
        this.checkInterval(n, 0, this.size() - 1);
        return this.root.get(n).getValue();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        this.checkInterval(n, 0, this.size());
        return new TreeListIterator(this, n);
    }

    @Override
    public int indexOf(Object object) {
        if (this.root == null) {
            return -1;
        }
        return this.root.indexOf(object, ((AVLNode)this.root).relativePosition);
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        if (this.root != null) {
            this.root.toArray(objectArray, ((AVLNode)this.root).relativePosition);
        }
        return objectArray;
    }

    @Override
    public void add(int n, E e) {
        ++this.modCount;
        this.checkInterval(n, 0, this.size());
        this.root = this.root == null ? new AVLNode(n, e, null, null) : this.root.insert(n, e);
        ++this.size;
    }

    @Override
    public E set(int n, E e) {
        this.checkInterval(n, 0, this.size() - 1);
        AVLNode<E> aVLNode = this.root.get(n);
        Object object = ((AVLNode)aVLNode).value;
        aVLNode.setValue(e);
        return (E)object;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n != -1) {
            return this.remove(n) != null;
        }
        return false;
    }

    @Override
    public E remove(int n) {
        ++this.modCount;
        this.checkInterval(n, 0, this.size() - 1);
        E e = this.get(n);
        this.root = this.root.remove(n);
        --this.size;
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.root = null;
        this.size = 0;
    }

    private void checkInterval(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new IndexOutOfBoundsException("Invalid index:" + n + ", size=" + this.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TreeListIterator<E>
    implements ListIterator<E> {
        protected final TreeList<E> parent;
        protected AVLNode<E> next;
        protected int nextIndex;
        protected AVLNode<E> current;
        protected int currentIndex;
        protected int expectedModCount;

        protected TreeListIterator(TreeList<E> treeList, int n) throws IndexOutOfBoundsException {
            this.parent = treeList;
            this.expectedModCount = ((TreeList)treeList).modCount;
            this.next = ((TreeList)treeList).root == null ? null : ((TreeList)treeList).root.get(n);
            this.nextIndex = n;
            this.currentIndex = -1;
        }

        protected void checkModCount() {
            if (((TreeList)this.parent).modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.parent.size();
        }

        @Override
        public E next() {
            this.checkModCount();
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at index " + this.nextIndex + ".");
            }
            if (this.next == null) {
                this.next = ((TreeList)this.parent).root.get(this.nextIndex);
            }
            E e = this.next.getValue();
            this.current = this.next;
            this.currentIndex = this.nextIndex++;
            this.next = this.next.next();
            return e;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkModCount();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("Already at start of list.");
            }
            this.next = this.next == null ? ((TreeList)this.parent).root.get(this.nextIndex - 1) : this.next.previous();
            E e = this.next.getValue();
            this.current = this.next;
            this.currentIndex = --this.nextIndex;
            return e;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex() - 1;
        }

        @Override
        public void remove() {
            this.checkModCount();
            if (this.currentIndex == -1) {
                throw new IllegalStateException();
            }
            if (this.nextIndex == this.currentIndex) {
                this.next = this.next.next();
                this.parent.remove(this.currentIndex);
            } else {
                this.parent.remove(this.currentIndex);
                --this.nextIndex;
            }
            this.current = null;
            this.currentIndex = -1;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            this.checkModCount();
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.setValue(e);
        }

        @Override
        public void add(E e) {
            this.checkModCount();
            this.parent.add(this.nextIndex, e);
            this.current = null;
            this.currentIndex = -1;
            ++this.nextIndex;
            ++this.expectedModCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AVLNode<E> {
        private AVLNode<E> left;
        private boolean leftIsPrevious;
        private AVLNode<E> right;
        private boolean rightIsNext;
        private int height;
        private int relativePosition;
        private E value;

        private AVLNode(int n, E e, AVLNode<E> aVLNode, AVLNode<E> aVLNode2) {
            this.relativePosition = n;
            this.value = e;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = aVLNode;
            this.left = aVLNode2;
        }

        E getValue() {
            return this.value;
        }

        void setValue(E e) {
            this.value = e;
        }

        AVLNode<E> get(int n) {
            AVLNode<E> aVLNode;
            int n2 = n - this.relativePosition;
            if (n2 == 0) {
                return this;
            }
            AVLNode<E> aVLNode2 = aVLNode = n2 < 0 ? this.getLeftSubTree() : this.getRightSubTree();
            if (aVLNode == null) {
                return null;
            }
            return aVLNode.get(n2);
        }

        int indexOf(Object object, int n) {
            int n2;
            if (this.getLeftSubTree() != null && (n2 = this.left.indexOf(object, n + this.left.relativePosition)) != -1) {
                return n2;
            }
            if (this.value == null ? this.value == object : this.value.equals(object)) {
                return n;
            }
            if (this.getRightSubTree() != null) {
                return this.right.indexOf(object, n + this.right.relativePosition);
            }
            return -1;
        }

        void toArray(Object[] objectArray, int n) {
            objectArray[n] = this.value;
            if (this.getLeftSubTree() != null) {
                this.left.toArray(objectArray, n + this.left.relativePosition);
            }
            if (this.getRightSubTree() != null) {
                this.right.toArray(objectArray, n + this.right.relativePosition);
            }
        }

        AVLNode<E> next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return super.min();
        }

        AVLNode<E> previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return super.max();
        }

        AVLNode<E> insert(int n, E e) {
            int n2 = n - this.relativePosition;
            if (n2 <= 0) {
                return this.insertOnLeft(n2, e);
            }
            return this.insertOnRight(n2, e);
        }

        private AVLNode<E> insertOnLeft(int n, E e) {
            AVLNode<E> aVLNode = this;
            if (this.getLeftSubTree() == null) {
                this.setLeft(new AVLNode<E>(-1, e, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(n, e), null);
            }
            if (this.relativePosition >= 0) {
                ++this.relativePosition;
            }
            aVLNode = this.balance();
            super.recalcHeight();
            return aVLNode;
        }

        private AVLNode<E> insertOnRight(int n, E e) {
            AVLNode<E> aVLNode = this;
            if (this.getRightSubTree() == null) {
                this.setRight(new AVLNode<E>(1, e, this.right, this), null);
            } else {
                this.setRight(this.right.insert(n, e), null);
            }
            if (this.relativePosition < 0) {
                --this.relativePosition;
            }
            aVLNode = this.balance();
            super.recalcHeight();
            return aVLNode;
        }

        private AVLNode<E> getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private AVLNode<E> getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private AVLNode<E> max() {
            return this.getRightSubTree() == null ? this : super.max();
        }

        private AVLNode<E> min() {
            return this.getLeftSubTree() == null ? this : super.min();
        }

        AVLNode<E> remove(int n) {
            int n2 = n - this.relativePosition;
            if (n2 == 0) {
                return this.removeSelf();
            }
            if (n2 > 0) {
                this.setRight(this.right.remove(n2), this.right.right);
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                this.setLeft(this.left.remove(n2), this.left.left);
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode<E> removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(super.removeMax(), this.right.right);
            if (this.relativePosition < 0) {
                ++this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode<E> removeMin() {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(super.removeMin(), this.left.left);
            if (this.relativePosition > 0) {
                --this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode<E> removeSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                if (this.relativePosition > 0) {
                    this.left.relativePosition = this.left.relativePosition + (this.relativePosition + (this.relativePosition > 0 ? 0 : 1));
                }
                super.setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                this.right.relativePosition = this.right.relativePosition + (this.relativePosition - (this.relativePosition < 0 ? 0 : 1));
                super.setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                AVLNode<E> aVLNode = super.min();
                this.value = aVLNode.value;
                if (this.leftIsPrevious) {
                    this.left = aVLNode.left;
                }
                this.right = super.removeMin();
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                AVLNode<E> aVLNode = super.max();
                this.value = aVLNode.value;
                if (this.rightIsNext) {
                    this.right = aVLNode.right;
                }
                AVLNode<E> aVLNode2 = this.left.left;
                this.left = super.removeMax();
                if (this.left == null) {
                    this.left = aVLNode2;
                    this.leftIsPrevious = true;
                }
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this;
        }

        private AVLNode<E> balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (super.heightRightMinusLeft() > 0) {
                        this.setLeft(super.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (super.heightRightMinusLeft() < 0) {
                        this.setRight(super.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(AVLNode aVLNode) {
            if (aVLNode == null) {
                return 0;
            }
            return aVLNode.relativePosition;
        }

        private int setOffset(AVLNode<E> aVLNode, int n) {
            if (aVLNode == null) {
                return 0;
            }
            int n2 = this.getOffset(aVLNode);
            aVLNode.relativePosition = n;
            return n2;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(AVLNode<E> aVLNode) {
            return aVLNode == null ? -1 : aVLNode.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private AVLNode<E> rotateLeft() {
            AVLNode<E> aVLNode = this.right;
            AVLNode<E> aVLNode2 = super.getLeftSubTree();
            int n = this.relativePosition + this.getOffset(aVLNode);
            int n2 = -aVLNode.relativePosition;
            int n3 = this.getOffset(aVLNode) + this.getOffset(aVLNode2);
            this.setRight(aVLNode2, aVLNode);
            super.setLeft(this, null);
            this.setOffset(aVLNode, n);
            this.setOffset(this, n2);
            this.setOffset(aVLNode2, n3);
            return aVLNode;
        }

        private AVLNode<E> rotateRight() {
            AVLNode<E> aVLNode = this.left;
            AVLNode<E> aVLNode2 = super.getRightSubTree();
            int n = this.relativePosition + this.getOffset(aVLNode);
            int n2 = -aVLNode.relativePosition;
            int n3 = this.getOffset(aVLNode) + this.getOffset(aVLNode2);
            this.setLeft(aVLNode2, aVLNode);
            super.setRight(this, null);
            this.setOffset(aVLNode, n);
            this.setOffset(this, n2);
            this.setOffset(aVLNode2, n3);
            return aVLNode;
        }

        private void setLeft(AVLNode<E> aVLNode, AVLNode<E> aVLNode2) {
            this.leftIsPrevious = aVLNode == null;
            this.left = this.leftIsPrevious ? aVLNode2 : aVLNode;
            this.recalcHeight();
        }

        private void setRight(AVLNode<E> aVLNode, AVLNode<E> aVLNode2) {
            this.rightIsNext = aVLNode == null;
            this.right = this.rightIsNext ? aVLNode2 : aVLNode;
            this.recalcHeight();
        }

        public String toString() {
            return "AVLNode(" + this.relativePosition + "," + (this.left != null) + "," + this.value + "," + (this.getRightSubTree() != null) + ", faedelung " + this.rightIsNext + " )";
        }
    }
}

