/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Periodic {
    private static final long NANO_ORIGIN = System.nanoTime();
    private final ScheduledExecutorService scheduler;
    private final Delegate d;
    private long nextExecuteTime;
    private Future future;

    private static long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    public Periodic(Runnable runnable, ScheduledExecutorService scheduledExecutorService) {
        this.d = new Delegate(runnable);
        this.scheduler = scheduledExecutorService;
    }

    public synchronized boolean rescheduleIfLater(long l) {
        l = TimeUnit.MILLISECONDS.toNanos(l);
        long l2 = Periodic.now();
        if (Long.MAX_VALUE - l2 < l) {
            l = Long.MAX_VALUE - l2;
        }
        long l3 = l2 + l;
        if (this.future == null) {
            this.nextExecuteTime = l3;
            if (l > 0L) {
                this.future = this.scheduler.schedule(this.d, l, TimeUnit.NANOSECONDS);
            } else {
                this.scheduler.execute(this.d);
            }
            return true;
        }
        if (l3 > this.nextExecuteTime) {
            this.nextExecuteTime = l3;
            return true;
        }
        return false;
    }

    public synchronized boolean rescheduleIfSooner(long l) {
        long l2;
        if (this.future == null) {
            return this.rescheduleIfLater(l);
        }
        l = TimeUnit.MILLISECONDS.toNanos(l);
        long l3 = Periodic.now();
        if (Long.MAX_VALUE - l3 < l) {
            l = Long.MAX_VALUE - l3;
        }
        if ((l2 = l3 + l) < this.nextExecuteTime) {
            this.future.cancel(false);
            this.nextExecuteTime = l2;
            if (l > 0L) {
                this.future = this.scheduler.schedule(this.d, l, TimeUnit.NANOSECONDS);
            } else {
                this.future = null;
                this.scheduler.execute(this.d);
            }
            return true;
        }
        return false;
    }

    public synchronized void unschedule() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
            this.nextExecuteTime = -1L;
        }
    }

    protected Runnable getRunnable() {
        return this.d.r;
    }

    private class Delegate
    implements Runnable {
        private final Runnable r;

        Delegate(Runnable runnable) {
            this.r = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Periodic periodic = Periodic.this;
            synchronized (periodic) {
                Periodic.this.future = null;
                long l = Periodic.now();
                if (l < Periodic.this.nextExecuteTime) {
                    Periodic.this.future = Periodic.this.scheduler.schedule(this, Math.max(0L, Periodic.this.nextExecuteTime - l), TimeUnit.NANOSECONDS);
                    return;
                }
            }
            this.r.run();
        }
    }
}

