/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Collection;
import org.limewire.collection.MultiIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiCollection<T>
extends MultiIterable<T>
implements Collection<T> {
    private final Iterable<Collection<? extends T>> collections;

    public MultiCollection(Collection<? extends T> collection, Collection<? extends T> collection2) {
        super(collection, collection2);
        ArrayList<Collection<T>> arrayList = new ArrayList<Collection<T>>(2);
        arrayList.add(collection);
        arrayList.add(collection2);
        this.collections = arrayList;
    }

    public MultiCollection(Collection<? extends T> ... collectionArray) {
        super((Iterable[])collectionArray);
        ArrayList<Collection<T>> arrayList = new ArrayList<Collection<T>>(collectionArray.length);
        for (Collection<? extends T> collection : collectionArray) {
            arrayList.add(collection);
        }
        this.collections = arrayList;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        for (Collection<T> collection : this.collections) {
            collection.clear();
        }
    }

    @Override
    public boolean contains(Object object) {
        for (Collection<T> collection : this.collections) {
            if (!collection.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<T> collection : this.collections) {
            if (collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object object) {
        for (Collection<T> collection : this.collections) {
            if (!collection.remove(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        for (Collection<T> collection2 : this.collections) {
            if (!collection2.retainAll(collection)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public int size() {
        int n = 0;
        for (Collection<T> collection : this.collections) {
            n += collection.size();
        }
        return n;
    }

    @Override
    public Object[] toArray() {
        ArrayList<? extends T> arrayList = new ArrayList<T>(this.size());
        for (Collection<? extends T> collection : this.collections) {
            arrayList.addAll(collection);
        }
        return arrayList.toArray();
    }

    @Override
    public <B> B[] toArray(B[] BArray) {
        ArrayList<? extends T> arrayList = new ArrayList<T>(this.size());
        for (Collection<? extends T> collection : this.collections) {
            arrayList.addAll(collection);
        }
        return arrayList.toArray(BArray);
    }
}

