/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.SortedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedsizePriorityQueue<E>
implements Iterable<E> {
    private SortedList<E> tree;
    private int capacity;

    public FixedsizePriorityQueue(Comparator<? super E> comparator, int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.tree = new SortedList<E>(comparator);
        this.capacity = n;
    }

    public void clear() {
        this.tree.clear();
    }

    public boolean isFull() {
        return this.size() >= this.capacity();
    }

    public E insert(E e) {
        if (!this.isFull()) {
            boolean bl = this.tree.add(e);
            assert (bl);
            return null;
        }
        E e2 = this.tree.first();
        if (this.tree.comparator().compare(e, e2) > 0) {
            this.tree.remove(e2);
            boolean bl = this.tree.add(e);
            assert (bl);
            return e2;
        }
        return e;
    }

    public E extractMax() {
        E e = this.getMax();
        this.remove(e);
        return e;
    }

    public E getMax() throws NoSuchElementException {
        return this.tree.last();
    }

    public E getMin() throws NoSuchElementException {
        return this.tree.first();
    }

    public boolean contains(Object object) {
        return this.tree.contains(object);
    }

    public boolean remove(Object object) {
        return this.tree.remove(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.tree.iterator();
    }

    public int size() {
        return this.tree.size();
    }

    public int capacity() {
        return this.capacity;
    }

    public String toString() {
        return this.tree.toString();
    }
}

