/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoublyLinkedList<E>
implements Iterable<ListElement<E>> {
    private ListElement<E> start = new ListElement<Object>(null);
    private ListElement<E> last = new ListElement<Object>(null);

    public DoublyLinkedList() {
        this.start.next = this.last;
        this.last.prev = this.start;
    }

    public ListElement<E> addLast(E e) {
        ListElement<E> listElement = new ListElement<E>(e);
        listElement.prev = this.last.prev;
        listElement.next = this.last;
        listElement.prev.next = listElement;
        this.last.prev = listElement;
        return listElement;
    }

    public ListElement<E> removeFirst() {
        if (this.start.next == this.last) {
            return null;
        }
        ListElement listElement = this.start.next;
        this.start.next = this.start.next.next;
        this.start.next.prev = this.start;
        return listElement;
    }

    public void remove(ListElement<E> listElement) {
        if (listElement == null || listElement.prev == null || listElement.next == null) {
            return;
        }
        if (listElement == this.start || listElement == this.last) {
            return;
        }
        listElement.prev.next = listElement.next;
        listElement.next.prev = listElement.prev;
    }

    public void clear() {
        this.start.next = this.last;
        this.last.prev = this.start;
    }

    @Override
    public Iterator<ListElement<E>> iterator() {
        return new DoublyLinkedListIterator();
    }

    public boolean contains(ListElement<E> listElement) {
        for (ListElement<E> listElement2 : this) {
            if (!listElement.equals(listElement2)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListElement<E> {
        E key;
        ListElement<E> prev;
        ListElement<E> next;

        ListElement(E e) {
            this.key = e;
            this.prev = null;
            this.next = null;
        }

        public E getKey() {
            return this.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoublyLinkedListIterator
    extends UnmodifiableIterator<ListElement<E>> {
        private ListElement<E> next;

        private DoublyLinkedListIterator() {
            this.next = ((DoublyLinkedList)DoublyLinkedList.this).start.next;
        }

        @Override
        public boolean hasNext() {
            return this.next != DoublyLinkedList.this.last;
        }

        @Override
        public ListElement<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ListElement listElement = this.next;
            this.next = this.next.next;
            return listElement;
        }
    }
}

