/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.Txn;
import de.kapsi.net.daap.chunks.BooleanChunk;
import de.kapsi.net.daap.chunks.Chunk;
import de.kapsi.net.daap.chunks.DateChunk;
import de.kapsi.net.daap.chunks.LongChunk;
import de.kapsi.net.daap.chunks.SByteChunk;
import de.kapsi.net.daap.chunks.SShortChunk;
import de.kapsi.net.daap.chunks.StringChunk;
import de.kapsi.net.daap.chunks.UByteChunk;
import de.kapsi.net.daap.chunks.UIntChunk;
import de.kapsi.net.daap.chunks.UShortChunk;
import de.kapsi.net.daap.chunks.impl.ContainerItemId;
import de.kapsi.net.daap.chunks.impl.HasVideo;
import de.kapsi.net.daap.chunks.impl.ITMSArtistId;
import de.kapsi.net.daap.chunks.impl.ITMSComposerId;
import de.kapsi.net.daap.chunks.impl.ITMSGenreId;
import de.kapsi.net.daap.chunks.impl.ITMSPlaylistId;
import de.kapsi.net.daap.chunks.impl.ITMSSongId;
import de.kapsi.net.daap.chunks.impl.ITMSStorefrontId;
import de.kapsi.net.daap.chunks.impl.ItemId;
import de.kapsi.net.daap.chunks.impl.ItemKind;
import de.kapsi.net.daap.chunks.impl.ItemName;
import de.kapsi.net.daap.chunks.impl.NormVolume;
import de.kapsi.net.daap.chunks.impl.PersistentId;
import de.kapsi.net.daap.chunks.impl.Podcast;
import de.kapsi.net.daap.chunks.impl.SongAlbum;
import de.kapsi.net.daap.chunks.impl.SongArtist;
import de.kapsi.net.daap.chunks.impl.SongBeatsPerMinute;
import de.kapsi.net.daap.chunks.impl.SongBitrate;
import de.kapsi.net.daap.chunks.impl.SongCategory;
import de.kapsi.net.daap.chunks.impl.SongCodecSubtype;
import de.kapsi.net.daap.chunks.impl.SongCodecType;
import de.kapsi.net.daap.chunks.impl.SongComment;
import de.kapsi.net.daap.chunks.impl.SongCompilation;
import de.kapsi.net.daap.chunks.impl.SongComposer;
import de.kapsi.net.daap.chunks.impl.SongContentDescription;
import de.kapsi.net.daap.chunks.impl.SongContentRating;
import de.kapsi.net.daap.chunks.impl.SongDataKind;
import de.kapsi.net.daap.chunks.impl.SongDataUrl;
import de.kapsi.net.daap.chunks.impl.SongDateAdded;
import de.kapsi.net.daap.chunks.impl.SongDateModified;
import de.kapsi.net.daap.chunks.impl.SongDescription;
import de.kapsi.net.daap.chunks.impl.SongDisabled;
import de.kapsi.net.daap.chunks.impl.SongDiscCount;
import de.kapsi.net.daap.chunks.impl.SongDiscNumber;
import de.kapsi.net.daap.chunks.impl.SongEqPreset;
import de.kapsi.net.daap.chunks.impl.SongFormat;
import de.kapsi.net.daap.chunks.impl.SongGenre;
import de.kapsi.net.daap.chunks.impl.SongGrouping;
import de.kapsi.net.daap.chunks.impl.SongKeywords;
import de.kapsi.net.daap.chunks.impl.SongLongDescription;
import de.kapsi.net.daap.chunks.impl.SongRelativeVolume;
import de.kapsi.net.daap.chunks.impl.SongSampleRate;
import de.kapsi.net.daap.chunks.impl.SongSize;
import de.kapsi.net.daap.chunks.impl.SongStartTime;
import de.kapsi.net.daap.chunks.impl.SongStopTime;
import de.kapsi.net.daap.chunks.impl.SongTime;
import de.kapsi.net.daap.chunks.impl.SongTrackCount;
import de.kapsi.net.daap.chunks.impl.SongTrackNumber;
import de.kapsi.net.daap.chunks.impl.SongUserRating;
import de.kapsi.net.daap.chunks.impl.SongYear;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Song {
    private static long songId = 1L;
    private static final SongFormat FORMAT = new SongFormat("mp3");
    private static final SongSampleRate SAMPLE_RATE = new SongSampleRate(44100L);
    private final Map<String, Chunk> chunks = new HashMap<String, Chunk>();
    private final ItemKind itemKind = new ItemKind(2);
    private final ItemId itemId = new ItemId();
    private final ItemName itemName = new ItemName();
    private final ContainerItemId containerItemId = new ContainerItemId();
    private final PersistentId persistentId = new PersistentId();
    private SongAlbum album;
    private SongArtist artist;
    private SongBeatsPerMinute bpm;
    private SongBitrate bitrate;
    private SongComment comment;
    private SongCompilation compilation;
    private SongComposer composer;
    private SongDataKind dataKind;
    private SongDataUrl dataUrl;
    private SongDateAdded dateAdded;
    private SongDateModified dateModified;
    private SongDescription description;
    private SongDisabled disabled;
    private SongDiscCount discCount;
    private SongDiscNumber discNumber;
    private SongEqPreset eqPreset;
    private SongFormat format;
    private SongGenre genre;
    private SongRelativeVolume relativeVolume;
    private SongSampleRate sampleRate;
    private SongSize size;
    private SongStartTime startTime;
    private SongStopTime stopTime;
    private SongTime time;
    private SongTrackCount trackCount;
    private SongTrackNumber trackNumber;
    private SongUserRating userRating;
    private SongYear year;
    private SongGrouping grouping;
    private NormVolume normVolume;
    private SongCodecType codecType;
    private SongCodecSubtype codecSubtype;
    private ITMSArtistId itmsArtistId;
    private ITMSComposerId itmsComposerId;
    private ITMSGenreId itmsGenreId;
    private ITMSPlaylistId itmsPlaylistId;
    private ITMSStorefrontId itmsStorefrontId;
    private ITMSSongId itmsSongId;
    private Podcast podcast;
    private SongCategory category;
    private SongContentDescription contentDescription;
    private SongContentRating contentRating;
    private SongKeywords keywords;
    private SongLongDescription longDescription;
    private HasVideo hasVideo;
    private Object attachment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Song() {
        Class<Song> clazz = Song.class;
        synchronized (Song.class) {
            this.itemId.setValue(songId++);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.persistentId.setValue(this.itemId.getValue());
            this.containerItemId.setValue(this.itemId.getValue());
            this.init();
            return;
        }
    }

    public Song(String name) {
        this();
        this.itemName.setValue(name);
    }

    private void init() {
        this.addChunk(this.itemKind);
        this.addChunk(this.itemName);
        this.addChunk(this.itemId);
        this.addChunk(this.containerItemId);
        this.addChunk(FORMAT);
        this.addChunk(SAMPLE_RATE);
    }

    protected long getItemId() {
        return this.itemId.getUnsignedValue();
    }

    protected long getContainerId() {
        return this.containerItemId.getUnsignedValue();
    }

    public String getName() {
        return this.getStringValue(this.itemName);
    }

    public void setName(Transaction txn, String itemName) {
        this.setStringValue(txn, "itemName", itemName);
    }

    public void setAlbum(Transaction txn, String album) {
        this.setStringValue(txn, "album", album);
    }

    public String getAlbum() {
        return this.getStringValue(this.album);
    }

    public void setArtist(Transaction txn, String artist) {
        this.setStringValue(txn, "artist", artist);
    }

    public String getArtist() {
        return this.getStringValue(this.artist);
    }

    public void setBeatsPerMinute(Transaction txn, int bpm) {
        this.setUShortValue(txn, "bpm", bpm);
    }

    public int getBeatsPerMinute() {
        return this.getUShortValue(this.bpm);
    }

    public void setBitrate(Transaction txn, int bitrate) {
        this.setUShortValue(txn, "bitrate", bitrate);
    }

    public int getBitrate() {
        return this.getUShortValue(this.bitrate);
    }

    public void setComment(Transaction txn, String comment) {
        this.setStringValue(txn, "comment", comment);
    }

    public String getComment() {
        return this.getStringValue(this.comment);
    }

    public void setCompilation(Transaction txn, boolean compilation) {
        this.setBooleanValue(txn, "compilation", compilation);
    }

    public boolean isCompilation() {
        return this.getBooleanValue(this.compilation);
    }

    public void setComposer(Transaction txn, String composer) {
        this.setStringValue(txn, "composer", composer);
    }

    public String getComposer() {
        return this.getStringValue(this.composer);
    }

    public void setDataKind(Transaction txn, int dataKind) {
        this.setUByteValue(txn, "dataKind", dataKind);
    }

    public int getDataKind() {
        return this.getUByteValue(this.dataKind);
    }

    public void setDataUrl(Transaction txn, String dataUrl) {
        this.setStringValue(txn, "dataUrl", dataUrl);
    }

    public String getDataUrl() {
        return this.getStringValue(this.dataUrl);
    }

    public void setDateAdded(Transaction txn, long dateAdded) {
        this.setDateValue(txn, "dateAdded", dateAdded);
    }

    public long getDateAdded() {
        return this.getDateValue(this.dateAdded);
    }

    public void setDateModified(Transaction txn, long dateModified) {
        this.setDateValue(txn, "dateModified", dateModified);
    }

    public long getDateModified() {
        return this.getDateValue(this.dateModified);
    }

    public void setDescription(Transaction txn, String description) {
        this.setStringValue(txn, "description", description);
    }

    public String getDescription() {
        return this.getStringValue(this.description);
    }

    public void setDisabled(Transaction txn, boolean disabled) {
        this.setBooleanValue(txn, "disabled", disabled);
    }

    public boolean isDisabled() {
        return this.getBooleanValue(this.disabled);
    }

    public void setDiscCount(Transaction txn, int discCount) {
        this.setUShortValue(txn, "discCount", discCount);
    }

    public int getDiscCount() {
        return this.getUShortValue(this.discCount);
    }

    public void setDiscNumber(Transaction txn, int discNumber) {
        this.setUShortValue(txn, "discNumber", discNumber);
    }

    public int getDiscNumber() {
        return this.getUShortValue(this.discNumber);
    }

    public void setEqPreset(Transaction txn, String eqPreset) {
        this.setStringValue(txn, "eqPreset", eqPreset);
    }

    public String getEqPreset() {
        return this.getStringValue(this.eqPreset);
    }

    public void setFormat(Transaction txn, String format) {
        this.setStringValue(txn, "format", format);
    }

    public String getFormat() {
        return this.getStringValue(this.format);
    }

    public void setGenre(Transaction txn, String genre) {
        this.setStringValue(txn, "genre", genre);
    }

    public String getGenre() {
        return this.getStringValue(this.genre);
    }

    public void setRelativeVolume(Transaction txn, int relativeVolume) {
        this.setSByteValue(txn, "relativeVolume", relativeVolume);
    }

    public int getRelativeVolume() {
        return this.getSByteValue(this.relativeVolume);
    }

    public void setSampleRate(Transaction txn, long sampleRate) {
        this.setUIntValue(txn, "sampleRate", sampleRate);
    }

    public long getSampleRate() {
        return this.getUIntValue(this.sampleRate);
    }

    public void setSize(Transaction txn, long size) {
        this.setUIntValue(txn, "size", size);
    }

    public long getSize() {
        return this.getUIntValue(this.size);
    }

    public void setStartTime(Transaction txn, long startTime) {
        this.setUIntValue(txn, "startTime", startTime);
    }

    public long getStartTime() {
        return this.getUIntValue(this.startTime);
    }

    public void setStopTime(Transaction txn, long stopTime) {
        this.setUIntValue(txn, "stopTime", stopTime);
    }

    public long getStopTime() {
        return this.getUIntValue(this.stopTime);
    }

    public void setTime(Transaction txn, long time) {
        this.setUIntValue(txn, "time", time);
    }

    public long getTime() {
        return this.getUIntValue(this.time);
    }

    public void setTrackCount(Transaction txn, int trackCount) {
        this.setUShortValue(txn, "trackCount", trackCount);
    }

    public int getTrackCount() {
        return this.getUShortValue(this.trackCount);
    }

    public void setTrackNumber(Transaction txn, int trackNumber) {
        this.setUShortValue(txn, "trackNumber", trackNumber);
    }

    public int getTrackNumber() {
        return this.getUShortValue(this.trackNumber);
    }

    public void setUserRating(Transaction txn, int userRating) {
        this.setUByteValue(txn, "userRating", userRating);
    }

    public int getUserRating() {
        return this.getUByteValue(this.userRating);
    }

    public void setYear(Transaction txn, int year) {
        this.setUShortValue(txn, "year", year);
    }

    public int getYear() {
        return this.getUShortValue(this.year);
    }

    public void setGrouping(Transaction txn, String grouping) {
        this.setStringValue(txn, "grouping", grouping);
    }

    public String getGrouping() {
        return this.getStringValue(this.grouping);
    }

    public void setITMSArtistId(Transaction txn, long itmsArtistId) {
        this.setUIntValue(txn, "itmsArtistId", itmsArtistId);
    }

    public long getITMSArtistId() {
        return this.getUIntValue(this.itmsArtistId);
    }

    public void setITMSComposerId(Transaction txn, long itmsComposerId) {
        this.setUIntValue(txn, "itmsComposerId", itmsComposerId);
    }

    public long getITMSComposerId() {
        return this.getUIntValue(this.itmsComposerId);
    }

    public void setITMSGenreId(Transaction txn, long itmsGenreId) {
        this.setUIntValue(txn, "itmsGenreId", itmsGenreId);
    }

    public long getITMSGenreId() {
        return this.getUIntValue(this.itmsGenreId);
    }

    public void setITMSPlaylistId(Transaction txn, long itmsPlaylistId) {
        this.setUIntValue(txn, "itmsPlaylistId", itmsPlaylistId);
    }

    public long getITMSPlaylistId() {
        return this.getUIntValue(this.itmsPlaylistId);
    }

    public void setITMSStorefrontId(Transaction txn, long itmsStorefrontId) {
        this.setUIntValue(txn, "itmsStorefrontId", itmsStorefrontId);
    }

    public long getITMSStrorefrontId() {
        return this.getUIntValue(this.itmsStorefrontId);
    }

    public void setITMSSongId(Transaction txn, long itmsSongId) {
        this.setUIntValue(txn, "itmsSongId", itmsSongId);
    }

    public long getITMSSongId() {
        return this.getUIntValue(this.itmsSongId);
    }

    public void setCodecType(Transaction txn, long codecType) {
        this.setUIntValue(txn, "codecType", codecType);
    }

    public long getCodecType() {
        return this.getUIntValue(this.codecType);
    }

    public void setCodecSubtype(Transaction txn, long codecSubtype) {
        this.setUIntValue(txn, "codecSubtype", codecSubtype);
    }

    public long getCodecSubtype() {
        return this.getUIntValue(this.codecSubtype);
    }

    public void setNormVolume(Transaction txn, long normVolume) {
        this.setUIntValue(txn, "normVolume", normVolume);
    }

    public long getNormVolume() {
        return this.getUIntValue(this.normVolume);
    }

    public void setPodcast(Transaction txn, boolean podcast) {
        this.setBooleanValue(txn, "podcast", podcast);
    }

    public boolean isPodcast() {
        return this.getBooleanValue(this.podcast);
    }

    public void setCategory(Transaction txn, String category) {
        this.setStringValue(txn, "category", category);
    }

    public String getCategory() {
        return this.getStringValue(this.category);
    }

    public void setContentDescription(Transaction txn, String contentDescription) {
        this.setStringValue(txn, "contentDescription", contentDescription);
    }

    public String getContentDescription() {
        return this.getStringValue(this.contentDescription);
    }

    public void setContentRating(Transaction txn, int contentRating) {
        this.setUByteValue(txn, "contentRating", contentRating);
    }

    public int getContentRating() {
        return this.getUByteValue(this.contentRating);
    }

    public void setKeywords(Transaction txn, String keywords) {
        this.setStringValue(txn, "keywords", keywords);
    }

    public String getKeywords() {
        return this.getStringValue(this.keywords);
    }

    public void setLongDescription(Transaction txn, String longDescription) {
        this.setStringValue(txn, "longDescription", longDescription);
    }

    public String getLongDescription() {
        return this.getStringValue(this.longDescription);
    }

    public void setHasVideo(Transaction txn, boolean hasVideo) {
        this.setBooleanValue(txn, "hasVideo", hasVideo);
    }

    public boolean hasVideo() {
        return this.getBooleanValue(this.hasVideo);
    }

    private void addChunk(Chunk chunk) {
        if (chunk != null) {
            this.chunks.put(chunk.getName(), chunk);
        }
    }

    protected Chunk getChunk(String name) {
        return this.chunks.get(name);
    }

    public Object setAttachment(Object attachment) {
        Object old = this.attachment;
        this.attachment = attachment;
        return old;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Name: ").append(this.getName()).append("\n");
        buffer.append("ID: ").append(this.getItemId()).append("\n");
        buffer.append("Artist: ").append(this.getArtist()).append("\n");
        buffer.append("Album: ").append(this.getAlbum()).append("\n");
        buffer.append("Bitrate: ").append(this.getBitrate()).append("\n");
        buffer.append("Genre: ").append(this.getGenre()).append("\n");
        buffer.append("Comment: ").append(this.getComment()).append("\n");
        return buffer.append("\n").toString();
    }

    public int hashCode() {
        return (int)this.getItemId();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Song)) {
            return false;
        }
        return ((Song)o).getItemId() == this.getItemId();
    }

    protected void setBooleanValue(Transaction txn, String fieldName, boolean value) {
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected void setUByteValue(Transaction txn, String fieldName, int value) {
        UByteChunk.checkUByteRange(value);
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected void setSByteValue(Transaction txn, String fieldName, int value) {
        SByteChunk.checkSByteRange(value);
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected void setUShortValue(Transaction txn, String fieldName, int value) {
        UShortChunk.checkUShortRange(value);
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected void setSShortValue(Transaction txn, String fieldName, int value) {
        SShortChunk.checkSShortRange(value);
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected void setUIntValue(Transaction txn, String fieldName, long value) {
        UIntChunk.checkUIntRange(value);
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected void setSIntValue(Transaction txn, String fieldName, int value) {
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected void setULongValue(Transaction txn, String fieldName, long value) {
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected void setSLongValue(Transaction txn, String fieldName, long value) {
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected void setStringValue(Transaction txn, String fieldName, String value) {
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected void setDateValue(Transaction txn, String fieldName, long value) {
        DateChunk.checkDateRange(value);
        if (txn != null) {
            txn.addTxn(this, this.createNewTxn(fieldName, value));
        } else {
            this.setValue(fieldName, value);
        }
    }

    protected boolean getBooleanValue(BooleanChunk chunk) {
        return chunk != null ? chunk.getBooleanValue() : false;
    }

    protected int getSByteValue(SByteChunk chunk) {
        return chunk != null ? chunk.getValue() : 0;
    }

    protected int getUByteValue(UByteChunk chunk) {
        return chunk != null ? chunk.getValue() : 0;
    }

    protected int getUShortValue(UShortChunk chunk) {
        return chunk != null ? chunk.getValue() : 0;
    }

    protected long getUIntValue(UIntChunk chunk) {
        return chunk != null ? chunk.getUnsignedValue() : 0L;
    }

    protected long getLongValue(LongChunk chunk) {
        return chunk != null ? chunk.getValue() : 0L;
    }

    protected long getDateValue(DateChunk chunk) {
        return chunk != null ? chunk.getValue() : 0L;
    }

    protected String getStringValue(StringChunk chunk) {
        return chunk != null ? chunk.getValue() : null;
    }

    protected Txn createNewTxn(String name, boolean value) {
        return this.createNewTxn(name, Boolean.TYPE, new Boolean(value));
    }

    protected Txn createNewTxn(String name, int value) {
        return this.createNewTxn(name, Integer.TYPE, new Integer(value));
    }

    protected Txn createNewTxn(String name, long value) {
        return this.createNewTxn(name, Long.TYPE, new Long(value));
    }

    protected Txn createNewTxn(String name, String value) {
        return this.createNewTxn(name, String.class, value);
    }

    protected Txn createNewTxn(final String fieldName, final Class valueClass, final Object value) {
        Txn txn = new Txn(){

            public void commit(Transaction txn) {
                Song.this.setValue(fieldName, valueClass, value);
            }
        };
        return txn;
    }

    protected void setValue(String fieldName, boolean value) {
        this.setValue(fieldName, Boolean.TYPE, new Boolean(value));
    }

    protected void setValue(String fieldName, int value) {
        this.setValue(fieldName, Integer.TYPE, new Integer(value));
    }

    protected void setValue(String fieldName, long value) {
        this.setValue(fieldName, Long.TYPE, new Long(value));
    }

    protected void setValue(String fieldName, String value) {
        this.setValue(fieldName, String.class, value);
    }

    protected void setValue(String fieldName, Class valueClass, Object value) {
        try {
            Field field = Song.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            Chunk chunk = (Chunk)field.get(this);
            if (chunk == null) {
                Constructor<?> con = field.getType().getConstructor(valueClass);
                chunk = (Chunk)con.newInstance(value);
                field.set(this, chunk);
                this.addChunk(chunk);
            } else {
                Method method = field.getType().getMethod("setValue", valueClass);
                method.invoke((Object)chunk, value);
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

