/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.SessionId;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaapRequest {
    public static final String AUTHORIZATION = "Authorization";
    public static final String CLIENT_DAAP_VERSION = "Client-DAAP-Version";
    public static final String USER_AGENT = "User-Agent";
    public static final int SERVER_INFO = 1;
    public static final int CONTENT_CODES = 2;
    public static final int LOGIN = 3;
    public static final int LOGOUT = 4;
    public static final int UPDATE = 5;
    public static final int RESOLVE = 6;
    public static final int DATABASES = 7;
    public static final int DATABASE_SONGS = 8;
    public static final int DATABASE_PLAYLISTS = 9;
    public static final int PLAYLIST_SONGS = 10;
    public static final int SONG = 11;
    private static final Log LOG = LogFactory.getLog(DaapRequest.class);
    private URI uri;
    private Map<String, String> queryMap;
    private SessionId sessionId;
    private int revisionNumber;
    private int delta;
    private List<String> meta;
    private String metaString;
    private int requestType;
    private long databaseId;
    private long containerId;
    private long itemId;
    private List<Header> headers;
    private boolean isServerSideRequest;
    private boolean isUpdateType;
    private DaapConnection connection;

    private DaapRequest(DaapConnection connection) {
        this.sessionId = SessionId.INVALID;
        this.revisionNumber = 0;
        this.delta = 0;
        this.requestType = 0;
        this.databaseId = 0L;
        this.containerId = 0L;
        this.itemId = 0L;
        this.connection = connection;
        this.headers = new ArrayList<Header>();
    }

    public DaapRequest(DaapConnection connection, SessionId sessionId, int revisionNumber, int delta) {
        this(connection);
        this.sessionId = sessionId;
        this.revisionNumber = revisionNumber;
        this.delta = delta;
        this.requestType = 5;
        this.isServerSideRequest = true;
        this.isUpdateType = false;
    }

    public DaapRequest(DaapConnection connection, String requestLine) throws URISyntaxException {
        URI uri;
        block5: {
            this(connection);
            uri = null;
            try {
                StringTokenizer st;
                block4: {
                    st = new StringTokenizer(requestLine, " ");
                    st.nextToken();
                    try {
                        uri = new URI(st.nextToken());
                    }
                    catch (URISyntaxException err) {
                        if (!LOG.isErrorEnabled()) break block4;
                        LOG.error((Object)err);
                    }
                }
                st.nextToken();
            }
            catch (NoSuchElementException err) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)err);
            }
        }
        this.isServerSideRequest = false;
        this.isUpdateType = false;
        this.setURI(uri);
    }

    public DaapRequest(DaapConnection connection, String method, URI uri, String protocol) throws URISyntaxException {
        this(connection);
        this.isServerSideRequest = false;
        this.isUpdateType = false;
        this.setURI(uri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setURI(URI uri) throws URISyntaxException {
        this.uri = uri;
        if (uri != null) {
            String path = uri.getPath();
            this.queryMap = DaapUtil.parseQuery(uri.getQuery());
            if (path.equals("/server-info")) {
                this.requestType = 1;
            } else if (path.equals("/content-codes")) {
                this.requestType = 2;
            } else if (path.equals("/login")) {
                this.requestType = 3;
            } else if (path.equals("/logout")) {
                this.requestType = 4;
            } else if (path.equals("/update")) {
                this.requestType = 5;
            } else if (path.equals("/resolve")) {
                this.requestType = 6;
            }
            if (this.queryMap.containsKey("session-id")) {
                this.sessionId = SessionId.parseSessionId(this.queryMap.get("session-id"));
            }
            if (SessionId.INVALID.equals(this.sessionId)) return;
            if (this.queryMap.containsKey("revision-number")) {
                this.revisionNumber = Integer.parseInt(this.queryMap.get("revision-number"));
            }
            if (this.queryMap.containsKey("delta")) {
                this.delta = Integer.parseInt(this.queryMap.get("delta"));
            }
            if (this.delta > this.revisionNumber) {
                throw new URISyntaxException(uri.toASCIIString(), "Delta must be less or equal to revision-number: " + this.delta + "/" + this.revisionNumber);
            }
            if (this.queryMap.containsKey("meta")) {
                this.metaString = this.queryMap.get("meta");
            }
            boolean bl = this.isUpdateType = this.delta != 0 && this.delta < this.revisionNumber;
            if (path.equals("/databases")) {
                this.requestType = 7;
                return;
            } else {
                if (!path.startsWith("/databases")) return;
                StringTokenizer tok = new StringTokenizer(path, "/");
                int count = tok.countTokens();
                if (count < 3) throw new URISyntaxException(uri.toASCIIString(), "Unknown token in path: " + path);
                String token = tok.nextToken();
                if (!token.equals("databases")) {
                    throw new URISyntaxException(uri.toASCIIString(), "Unknown token in path: " + path + " [" + token + "]@1");
                }
                this.databaseId = DaapUtil.parseUInt(tok.nextToken());
                token = tok.nextToken();
                if (token.equals("items")) {
                    this.requestType = 8;
                } else {
                    if (!token.equals("containers")) throw new URISyntaxException(uri.toASCIIString(), "Unknown token in path: " + path + " [" + token + "]@2");
                    this.requestType = 9;
                }
                if (count == 3) return;
                if (count == 4) {
                    token = tok.nextToken();
                    StringTokenizer fileTokenizer = new StringTokenizer(token, ".");
                    if (fileTokenizer.countTokens() != 2) throw new URISyntaxException(uri.toASCIIString(), "Unknown token in path: " + path + " [" + token + "]@3");
                    this.itemId = DaapUtil.parseUInt(fileTokenizer.nextToken());
                    this.requestType = 11;
                    return;
                } else {
                    if (count != 5) throw new URISyntaxException(uri.toASCIIString(), "Unknown token in path: " + path + " [" + token + "]@5");
                    this.containerId = DaapUtil.parseUInt(tok.nextToken());
                    token = tok.nextToken();
                    if (!token.equals("items")) throw new URISyntaxException(uri.toASCIIString(), "Unknown token in path: " + path + " [" + token + "@4");
                    this.requestType = 10;
                }
            }
            return;
        } else {
            this.queryMap = null;
            this.metaString = null;
            this.isUpdateType = false;
            this.requestType = 0;
            this.databaseId = 0L;
            this.containerId = 0L;
            this.itemId = 0L;
            this.sessionId = SessionId.INVALID;
            this.revisionNumber = 0;
            this.delta = 0;
        }
    }

    public void setSessionId(SessionId sessionId) {
        this.sessionId = sessionId;
    }

    public void addHeaders(Header[] headers) {
        for (Header header : headers) {
            this.headers.add(header);
        }
    }

    public void addHeaders(List<? extends Header> headers) {
        if (this.headers != headers) {
            this.headers.addAll(headers);
        }
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public Header getHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        for (Header header : this.headers) {
            if (!header.getName().equals(key)) continue;
            return header;
        }
        return null;
    }

    public DaapServer getServer() {
        return this.getConnection().getServer();
    }

    public DaapConnection getConnection() {
        return this.connection;
    }

    public boolean isUnknownRequest() {
        return this.requestType == 0;
    }

    public boolean isServerInfoRequest() {
        return this.requestType == 1;
    }

    public boolean isContentCodesRequest() {
        return this.requestType == 2;
    }

    public boolean isLoginRequest() {
        return this.requestType == 3;
    }

    public boolean isLogoutRequest() {
        return this.requestType == 4;
    }

    public boolean isUpdateRequest() {
        return this.requestType == 5;
    }

    public boolean isResolveRequest() {
        return this.requestType == 6;
    }

    public boolean isDatabasesRequest() {
        return this.requestType == 7;
    }

    public boolean isDatabaseSongsRequest() {
        return this.requestType == 8;
    }

    public boolean isDatabasePlaylistsRequest() {
        return this.requestType == 9;
    }

    public boolean isPlaylistSongsRequest() {
        return this.requestType == 10;
    }

    public boolean isSongRequest() {
        return this.requestType == 11;
    }

    public URI getUri() {
        return this.uri;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public int getDelta() {
        return this.delta;
    }

    public List<String> getMeta() {
        if (this.meta == null && this.metaString != null) {
            this.meta = DaapUtil.parseMeta(this.metaString);
            this.metaString = null;
        }
        if (this.meta != null) {
            return Collections.unmodifiableList(this.meta);
        }
        return Collections.emptyList();
    }

    public long getDatabaseId() {
        return this.databaseId;
    }

    public long getContainerId() {
        return this.containerId;
    }

    public long getItemId() {
        return this.itemId;
    }

    public boolean isDatabaseIdSet() {
        return this.databaseId != 0L;
    }

    public boolean isContainerIdSet() {
        return this.containerId != 0L;
    }

    public boolean isItemIdSet() {
        return this.itemId != 0L;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public Map<String, String> getQueryMap() {
        if (this.queryMap != null) {
            return Collections.unmodifiableMap(this.queryMap);
        }
        return Collections.emptyMap();
    }

    public boolean isServerSideRequest() {
        return this.isServerSideRequest;
    }

    public boolean isUpdateType() {
        return this.isUpdateType;
    }

    public boolean isGZIPSupported() {
        Header header = this.getHeader("Accept-Encoding");
        return header != null && header.getValue().equalsIgnoreCase("gzip");
    }

    public boolean isKeepConnectionAlive() {
        Header header = this.getHeader("Connection");
        return header != null && header.getValue().equalsIgnoreCase("keep-alive");
    }

    public Library getLibrary() {
        return this.connection.getServer().getLibrary();
    }

    public Library getHeadLibrary() {
        return this.connection.getFirstInQueue();
    }

    public Library nextLibrary() {
        return this.connection.nextLibrary(this);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isServerSideRequest) {
            buffer.append("ServerSideRequest: ").append(this.getRevisionNumber()).append(", ").append(this.getDelta()).append("\n");
        }
        if (this.uri != null) {
            buffer.append(this.uri).append("\n");
        }
        if (this.headers != null) {
            for (int i = 0; i < this.headers.size(); ++i) {
                buffer.append(this.headers.get(i));
            }
        }
        return buffer.toString();
    }
}

