/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.limewire.io.IOUtils;
import org.limewire.net.ConnectionDispatcher;

public class BlockingConnectionDispatcher
implements Runnable {
    private final ConnectionDispatcher dispatcher;
    private final Socket socket;
    private final String allowedWord;

    public BlockingConnectionDispatcher(ConnectionDispatcher connectionDispatcher, Socket socket, String string) {
        if (connectionDispatcher == null) {
            throw new IllegalArgumentException();
        }
        if (socket == null) {
            throw new IllegalArgumentException();
        }
        this.dispatcher = connectionDispatcher;
        this.socket = socket;
        this.allowedWord = string;
    }

    protected void shutdown() {
    }

    public void run() {
        try {
            InputStream inputStream = null;
            try {
                inputStream = this.socket.getInputStream();
            }
            catch (IOException iOException) {
                this.shutdown();
                throw iOException;
            }
            catch (NullPointerException nullPointerException) {
                throw new IOException(nullPointerException.getMessage());
            }
            String string = IOUtils.readLargestWord((InputStream)inputStream, (int)this.dispatcher.getMaximumWordSize());
            if (this.allowedWord != null && !this.allowedWord.equals(string)) {
                throw new IOException("wrong word!");
            }
            this.dispatcher.dispatch(string, this.socket, false);
        }
        catch (IOException iOException) {
            this.shutdown();
            IOUtils.close((Socket)this.socket);
        }
    }
}

