/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.nio.ByteBuffer;

public class ID3SyncSafeInteger {
    public static final int INTEGRAL_SIZE = 4;
    public static final int MAX_SAFE_SIZE = 127;

    private static int bufferToValue(byte[] buffer) {
        return ((buffer[0] & 0xFF) << 21) + ((buffer[1] & 0xFF) << 14) + ((buffer[2] & 0xFF) << 7) + (buffer[3] & 0xFF);
    }

    protected static int bufferToValue(ByteBuffer buffer) {
        byte[] byteBuffer = new byte[4];
        buffer.get(byteBuffer, 0, 4);
        return ID3SyncSafeInteger.bufferToValue(byteBuffer);
    }

    protected static boolean isBufferNotSyncSafe(ByteBuffer buffer) {
        int position = buffer.position();
        int i = 0;
        while (i < 4) {
            byte nextByte = buffer.get(position + i);
            if ((nextByte & 0x80) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean isBufferEmpty(byte[] buffer) {
        byte[] byArray = buffer;
        int n = buffer.length;
        int n2 = 0;
        while (n2 < n) {
            byte aBuffer = byArray[n2];
            if (aBuffer != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected static byte[] valueToBuffer(int size) {
        byte[] buffer = new byte[]{(byte)((size & 0xFE00000) >> 21), (byte)((size & 0x1FC000) >> 14), (byte)((size & 0x3F80) >> 7), (byte)(size & 0x7F)};
        return buffer;
    }
}

