/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.limewire.setting.AbstractSetting;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.BooleanSettingImpl;
import org.limewire.setting.ByteSetting;
import org.limewire.setting.CharArraySetting;
import org.limewire.setting.ColorSetting;
import org.limewire.setting.FileArraySetting;
import org.limewire.setting.FileSetSetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.FloatSetting;
import org.limewire.setting.FontNameSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.LongSetting;
import org.limewire.setting.NullRemoteManager;
import org.limewire.setting.PBooleanArraySetting;
import org.limewire.setting.PasswordSetting;
import org.limewire.setting.PowerOfTwoSetting;
import org.limewire.setting.ProbabilisticBooleanSetting;
import org.limewire.setting.ProxyFileSetting;
import org.limewire.setting.RemoteSettingController;
import org.limewire.setting.RemoteSettingManager;
import org.limewire.setting.StringArraySetting;
import org.limewire.setting.StringSetSetting;
import org.limewire.setting.StringSetting;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SettingsFactory
implements Iterable<AbstractSetting>,
RemoteSettingController {
    private static boolean loadSaveFailureEncountered = false;
    private static final long EXPIRY_INTERVAL = 1209600000L;
    private LongSetting LAST_EXPIRE_TIME = null;
    private File SETTINGS_FILE;
    private final String HEADING;
    protected final Properties DEFAULT_PROPS = new Properties();
    protected final Properties PROPS = new Properties(this.DEFAULT_PROPS);
    private ArrayList<AbstractSetting> settings = new ArrayList(10);
    private Map<String, AbstractSetting> remoteKeyToSetting = new HashMap<String, AbstractSetting>();
    private RemoteSettingManager remoteManager = new NullRemoteManager();
    private boolean expired = false;

    public SettingsFactory(File file) {
        this(file, "");
    }

    public SettingsFactory(File file, String string) {
        this.SETTINGS_FILE = file;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.HEADING = string;
        this.reload();
    }

    public static boolean hasLoadSaveFailure() {
        return loadSaveFailureEncountered;
    }

    private static void markFailure() {
        loadSaveFailureEncountered = true;
    }

    public static void resetLoadSaveFailure() {
        loadSaveFailureEncountered = false;
    }

    @Override
    public synchronized Iterator<AbstractSetting> iterator() {
        return this.settings.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload() {
        if (!this.SETTINGS_FILE.isFile()) {
            this.setExpireValue();
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.SETTINGS_FILE);
            try {
                this.PROPS.load(fileInputStream);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            }
            catch (IOException iOException) {
                SettingsFactory.markFailure();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            block10: {
                try {
                    if (!this.SETTINGS_FILE.exists()) break block10;
                    SettingsFactory.markFailure();
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
            }
            FileUtils.close((Closeable)fileInputStream);
        }
        FileUtils.close((Closeable)fileInputStream);
        for (AbstractSetting abstractSetting : this.settings) {
            abstractSetting.reload();
        }
        this.setExpireValue();
    }

    private synchronized void setExpireValue() {
        if (this.LAST_EXPIRE_TIME == null) {
            this.LAST_EXPIRE_TIME = this.createLongSetting("LAST_EXPIRE_TIME", 0L);
            boolean bl = this.expired = this.LAST_EXPIRE_TIME.getValue() + 1209600000L < System.currentTimeMillis();
            if (this.expired) {
                this.LAST_EXPIRE_TIME.setValue(System.currentTimeMillis());
            }
        }
    }

    public synchronized void changeFile(File file) {
        this.SETTINGS_FILE = file;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.revertToDefault();
        this.reload();
    }

    public synchronized boolean revertToDefault() {
        boolean bl = false;
        for (AbstractSetting abstractSetting : this.settings) {
            bl |= abstractSetting.revertToDefault();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        Properties properties = (Properties)this.PROPS.clone();
        for (AbstractSetting object2 : this.settings) {
            if (object2.shouldAlwaysSave() || !object2.isDefault()) continue;
            properties.remove(object2.getKey());
        }
        Object object = null;
        try {
            block13: {
                File iOException;
                if (this.SETTINGS_FILE.isDirectory()) {
                    this.SETTINGS_FILE.delete();
                }
                if ((iOException = this.SETTINGS_FILE.getParentFile()) != null) {
                    iOException.mkdirs();
                }
                FileUtils.setWriteable((File)this.SETTINGS_FILE);
                if (this.SETTINGS_FILE.exists() && !this.SETTINGS_FILE.canRead()) {
                    this.SETTINGS_FILE.delete();
                }
                try {
                    object = new BufferedOutputStream(new FileOutputStream(this.SETTINGS_FILE));
                }
                catch (IOException iOException2) {
                    if (!this.SETTINGS_FILE.exists()) break block13;
                    this.SETTINGS_FILE.delete();
                    object = new BufferedOutputStream(new FileOutputStream(this.SETTINGS_FILE));
                }
            }
            if (object != null) {
                properties.store((OutputStream)object, this.HEADING);
            } else {
                SettingsFactory.markFailure();
            }
            FileUtils.close((Closeable)object);
        }
        catch (IOException iOException) {
            SettingsFactory.markFailure();
        }
        finally {
            FileUtils.close(object);
        }
    }

    public String toString() {
        return this.PROPS.toString();
    }

    public Properties getProperties() {
        return this.PROPS;
    }

    public Properties getDefaultProperties() {
        return this.DEFAULT_PROPS;
    }

    public synchronized void setRemoteSettingManager(RemoteSettingManager remoteSettingManager) {
        this.remoteManager = remoteSettingManager;
        remoteSettingManager.setRemoteSettingController(this);
    }

    @Override
    public synchronized boolean updateSetting(String string, String string2) {
        AbstractSetting abstractSetting = this.remoteKeyToSetting.get(string);
        if (abstractSetting != null) {
            abstractSetting.setValueInternal(string2);
            return true;
        }
        return false;
    }

    public synchronized StringSetting createStringSetting(String string, String string2) {
        StringSetting stringSetting = new StringSetting(this.DEFAULT_PROPS, this.PROPS, string, string2);
        this.handleSettingInternal(stringSetting, null);
        return stringSetting;
    }

    public synchronized StringSetting createRemoteStringSetting(String string, String string2, String string3) {
        StringSetting stringSetting = new StringSetting(this.DEFAULT_PROPS, this.PROPS, string, string2);
        this.handleSettingInternal(stringSetting, string3);
        return stringSetting;
    }

    public synchronized BooleanSetting createBooleanSetting(String string, boolean bl) {
        BooleanSettingImpl booleanSettingImpl = new BooleanSettingImpl(this.DEFAULT_PROPS, this.PROPS, string, bl);
        this.handleSettingInternal(booleanSettingImpl, null);
        return booleanSettingImpl;
    }

    public synchronized BooleanSetting createRemoteBooleanSetting(String string, boolean bl, String string2) {
        BooleanSettingImpl booleanSettingImpl = new BooleanSettingImpl(this.DEFAULT_PROPS, this.PROPS, string, bl);
        this.handleSettingInternal(booleanSettingImpl, string2);
        return booleanSettingImpl;
    }

    public synchronized IntSetting createIntSetting(String string, int n) {
        IntSetting intSetting = new IntSetting(this.DEFAULT_PROPS, this.PROPS, string, n);
        this.handleSettingInternal(intSetting, null);
        return intSetting;
    }

    public synchronized IntSetting createRemoteIntSetting(String string, int n, String string2, int n2, int n3) {
        IntSetting intSetting = new IntSetting(this.DEFAULT_PROPS, this.PROPS, string, n, n2, n3);
        this.handleSettingInternal(intSetting, string2);
        return intSetting;
    }

    public synchronized ByteSetting createByteSetting(String string, byte by) {
        ByteSetting byteSetting = new ByteSetting(this.DEFAULT_PROPS, this.PROPS, string, by);
        this.handleSettingInternal(byteSetting, null);
        return byteSetting;
    }

    public synchronized ByteSetting createRemoteByteSetting(String string, byte by, String string2, byte by2, byte by3) {
        ByteSetting byteSetting = new ByteSetting(this.DEFAULT_PROPS, this.PROPS, string, by, by2, by3);
        this.handleSettingInternal(byteSetting, string2);
        return byteSetting;
    }

    public synchronized LongSetting createLongSetting(String string, long l) {
        LongSetting longSetting = new LongSetting(this.DEFAULT_PROPS, this.PROPS, string, l);
        this.handleSettingInternal(longSetting, null);
        return longSetting;
    }

    public synchronized LongSetting createRemoteLongSetting(String string, long l, String string2, long l2, long l3) {
        LongSetting longSetting = new LongSetting(this.DEFAULT_PROPS, this.PROPS, string, l, l2, l3);
        this.handleSettingInternal(longSetting, string2);
        return longSetting;
    }

    public synchronized PowerOfTwoSetting createPowerOfTwoSetting(String string, long l) {
        PowerOfTwoSetting powerOfTwoSetting = new PowerOfTwoSetting(this.DEFAULT_PROPS, this.PROPS, string, l);
        this.handleSettingInternal(powerOfTwoSetting, null);
        return powerOfTwoSetting;
    }

    public synchronized PowerOfTwoSetting createRemotePowerOfTwoSetting(String string, long l, String string2, long l2, long l3) {
        PowerOfTwoSetting powerOfTwoSetting = new PowerOfTwoSetting(this.DEFAULT_PROPS, this.PROPS, string, l, l2, l3);
        this.handleSettingInternal(powerOfTwoSetting, string2);
        return powerOfTwoSetting;
    }

    public synchronized FileSetting createFileSetting(String string, File file) {
        Object object;
        String string2 = file.getParent();
        if (string2 != null && !((File)(object = new File(string2))).isDirectory()) {
            ((File)object).mkdirs();
        }
        object = new FileSetting(this.DEFAULT_PROPS, this.PROPS, string, file);
        this.handleSettingInternal((AbstractSetting)object, null);
        return object;
    }

    public synchronized FileSetting createRemoteFileSetting(String string, File file, String string2) {
        Object object;
        String string3 = file.getParent();
        if (string3 != null && !((File)(object = new File(string3))).isDirectory()) {
            ((File)object).mkdirs();
        }
        object = new FileSetting(this.DEFAULT_PROPS, this.PROPS, string, file);
        this.handleSettingInternal((AbstractSetting)object, string2);
        return object;
    }

    public synchronized ProxyFileSetting createProxyFileSetting(String string, FileSetting fileSetting) {
        ProxyFileSetting proxyFileSetting = new ProxyFileSetting(this.DEFAULT_PROPS, this.PROPS, string, fileSetting);
        this.handleSettingInternal(proxyFileSetting, null);
        return proxyFileSetting;
    }

    public synchronized ColorSetting createColorSetting(String string, Color color) {
        ColorSetting colorSetting = ColorSetting.createColorSetting(this.DEFAULT_PROPS, this.PROPS, string, color);
        this.handleSettingInternal(colorSetting, null);
        return colorSetting;
    }

    public synchronized ColorSetting createRemoteColorSetting(String string, Color color, String string2) {
        ColorSetting colorSetting = ColorSetting.createColorSetting(this.DEFAULT_PROPS, this.PROPS, string, color);
        this.handleSettingInternal(colorSetting, string2);
        return colorSetting;
    }

    public synchronized CharArraySetting createCharArraySetting(String string, char[] cArray) {
        CharArraySetting charArraySetting = new CharArraySetting(this.DEFAULT_PROPS, this.PROPS, string, cArray);
        this.handleSettingInternal(charArraySetting, null);
        return charArraySetting;
    }

    public synchronized CharArraySetting createRemoteCharArraySetting(String string, char[] cArray, String string2) {
        CharArraySetting charArraySetting = new CharArraySetting(this.DEFAULT_PROPS, this.PROPS, string, cArray);
        this.handleSettingInternal(charArraySetting, string2);
        return charArraySetting;
    }

    public synchronized FloatSetting createFloatSetting(String string, float f) {
        FloatSetting floatSetting = new FloatSetting(this.DEFAULT_PROPS, this.PROPS, string, f);
        this.handleSettingInternal(floatSetting, null);
        return floatSetting;
    }

    public synchronized FloatSetting createRemoteFloatSetting(String string, float f, String string2, float f2, float f3) {
        FloatSetting floatSetting = new FloatSetting(this.DEFAULT_PROPS, this.PROPS, string, f, f2, f3);
        this.handleSettingInternal(floatSetting, string2);
        return floatSetting;
    }

    public synchronized StringArraySetting createStringArraySetting(String string, String[] stringArray) {
        StringArraySetting stringArraySetting = new StringArraySetting(this.DEFAULT_PROPS, this.PROPS, string, stringArray);
        this.handleSettingInternal(stringArraySetting, null);
        return stringArraySetting;
    }

    public synchronized StringArraySetting createRemoteStringArraySetting(String string, String[] stringArray, String string2) {
        StringArraySetting stringArraySetting = new StringArraySetting(this.DEFAULT_PROPS, this.PROPS, string, stringArray);
        this.handleSettingInternal(stringArraySetting, string2);
        return stringArraySetting;
    }

    public synchronized StringSetSetting createStringSetSetting(String string, String string2) {
        StringSetSetting stringSetSetting = new StringSetSetting(this.DEFAULT_PROPS, this.PROPS, string, string2);
        this.handleSettingInternal(stringSetSetting, null);
        return stringSetSetting;
    }

    public synchronized FileArraySetting createFileArraySetting(String string, File[] fileArray) {
        FileArraySetting fileArraySetting = new FileArraySetting(this.DEFAULT_PROPS, this.PROPS, string, fileArray);
        this.handleSettingInternal(fileArraySetting, null);
        return fileArraySetting;
    }

    public synchronized FileArraySetting createRemoteFileArraySetting(String string, File[] fileArray, String string2) {
        FileArraySetting fileArraySetting = new FileArraySetting(this.DEFAULT_PROPS, this.PROPS, string, fileArray);
        this.handleSettingInternal(fileArraySetting, string2);
        return fileArraySetting;
    }

    public synchronized FileSetSetting createFileSetSetting(String string, File[] fileArray) {
        FileSetSetting fileSetSetting = new FileSetSetting(this.DEFAULT_PROPS, this.PROPS, string, fileArray);
        this.handleSettingInternal(fileSetSetting, null);
        return fileSetSetting;
    }

    public synchronized FileSetSetting createRemoteFileSetSetting(String string, File[] fileArray, String string2) {
        FileSetSetting fileSetSetting = new FileSetSetting(this.DEFAULT_PROPS, this.PROPS, string, fileArray);
        this.handleSettingInternal(fileSetSetting, string2);
        return fileSetSetting;
    }

    public synchronized BooleanSetting createExpirableBooleanSetting(String string, boolean bl) {
        BooleanSetting booleanSetting = this.createBooleanSetting(string, bl);
        if (this.expired) {
            booleanSetting.revertToDefault();
        }
        return booleanSetting;
    }

    public synchronized IntSetting createExpirableIntSetting(String string, int n) {
        IntSetting intSetting = this.createIntSetting(string, n);
        if (this.expired) {
            intSetting.revertToDefault();
        }
        return intSetting;
    }

    public synchronized LongSetting createExpirableLongSetting(String string, long l) {
        LongSetting longSetting = this.createLongSetting(string, l);
        if (this.expired) {
            longSetting.revertToDefault();
        }
        return longSetting;
    }

    public synchronized FontNameSetting createFontNameSetting(String string, String string2) {
        FontNameSetting fontNameSetting = new FontNameSetting(this.DEFAULT_PROPS, this.PROPS, string, string2);
        this.handleSettingInternal(fontNameSetting, null);
        return fontNameSetting;
    }

    public synchronized FontNameSetting createRemoteFontNameSetting(String string, String string2, String string3) {
        FontNameSetting fontNameSetting = new FontNameSetting(this.DEFAULT_PROPS, this.PROPS, string, string2);
        this.handleSettingInternal(fontNameSetting, string3);
        return fontNameSetting;
    }

    public synchronized ProbabilisticBooleanSetting createProbabilisticBooleanSetting(String string, float f) {
        ProbabilisticBooleanSetting probabilisticBooleanSetting = new ProbabilisticBooleanSetting(this.DEFAULT_PROPS, this.PROPS, string, f);
        this.handleSettingInternal(probabilisticBooleanSetting, null);
        return probabilisticBooleanSetting;
    }

    public synchronized ProbabilisticBooleanSetting createRemoteProbabilisticBooleanSetting(String string, float f, String string2, float f2, float f3) {
        ProbabilisticBooleanSetting probabilisticBooleanSetting = new ProbabilisticBooleanSetting(this.DEFAULT_PROPS, this.PROPS, string, f, f2, f3);
        this.handleSettingInternal(probabilisticBooleanSetting, string2);
        return probabilisticBooleanSetting;
    }

    public synchronized PBooleanArraySetting createPBooleanArraySetting(String string, String[] stringArray) {
        PBooleanArraySetting pBooleanArraySetting = new PBooleanArraySetting(this.DEFAULT_PROPS, this.PROPS, string, stringArray);
        this.handleSettingInternal(pBooleanArraySetting, null);
        return pBooleanArraySetting;
    }

    public synchronized PBooleanArraySetting createRemotePBooleanArraySetting(String string, String[] stringArray, String string2) {
        PBooleanArraySetting pBooleanArraySetting = new PBooleanArraySetting(this.DEFAULT_PROPS, this.PROPS, string, stringArray);
        this.handleSettingInternal(pBooleanArraySetting, string2);
        return pBooleanArraySetting;
    }

    public synchronized PasswordSetting createPasswordSettingMD5(String string, String string2) {
        PasswordSetting passwordSetting = new PasswordSetting(this.DEFAULT_PROPS, this.PROPS, "MD5", string, string2);
        this.handleSettingInternal(passwordSetting, null);
        return passwordSetting;
    }

    private synchronized void handleSettingInternal(AbstractSetting abstractSetting, String string) {
        this.settings.add(abstractSetting);
        abstractSetting.reload();
        if (string != null) {
            if (this.remoteKeyToSetting.containsKey(string)) {
                throw new IllegalArgumentException("(SettingsFactory.handleSettingInsternal) duplicate setting remoteKey: " + string);
            }
            String string2 = this.remoteManager.getUnloadedValueFor(string);
            if (string2 != null) {
                abstractSetting.setValueInternal(string2);
            }
            this.remoteKeyToSetting.put(string, abstractSetting);
        }
    }
}

