/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.awt.Color;
import java.util.Properties;
import org.limewire.setting.AbstractSetting;

public final class ColorSetting
extends AbstractSetting {
    private Color value;

    static ColorSetting createColorSetting(Properties properties, Properties properties2, String string, Color color) {
        return new ColorSetting(properties, properties2, string, ColorSetting.formatColor(color));
    }

    private ColorSetting(Properties properties, Properties properties2, String string, String string2) {
        super(properties, properties2, string, string2);
    }

    public Color getValue() {
        return this.value;
    }

    public void setValue(Color color) {
        this.setValueInternal(ColorSetting.formatColor(color));
        this.value = color;
    }

    protected void loadValue(String string) {
        string = string.trim();
        try {
            int n = Integer.parseInt(string.substring(1, 3), 16);
            int n2 = Integer.parseInt(string.substring(3, 5), 16);
            int n3 = Integer.parseInt(string.substring(5, 7), 16);
            this.value = new Color(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            this.revertToDefault();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.revertToDefault();
        }
    }

    private static String formatColor(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        return "#" + string + string2 + string3;
    }
}

