/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.io.File;
import java.util.Properties;
import org.limewire.setting.AbstractSetting;
import org.limewire.setting.AbstractSettingsGroup;
import org.limewire.setting.Setting;
import org.limewire.setting.SettingsFactory;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.setting.evt.SettingsGroupEvent;

public class BasicSettingsGroup
extends AbstractSettingsGroup {
    private final File PROPS_FILE;
    private final SettingsFactory FACTORY;

    protected BasicSettingsGroup(File file, String string) {
        this.PROPS_FILE = file;
        this.FACTORY = new SettingsFactory(this.PROPS_FILE, string);
        SettingsGroupManager.instance().addSettingsGroup(this);
    }

    public Properties getProperties() {
        return this.FACTORY.getProperties();
    }

    public File getPropertiesFile() {
        return this.PROPS_FILE;
    }

    public SettingsFactory getFactory() {
        return this.FACTORY;
    }

    public void reload() {
        this.FACTORY.reload();
        this.fireSettingsEvent(SettingsGroupEvent.EventType.RELOAD);
    }

    public boolean save() {
        if (this.getShouldSave()) {
            this.FACTORY.save();
            this.fireSettingsEvent(SettingsGroupEvent.EventType.SAVE);
            return true;
        }
        return false;
    }

    public boolean revertToDefault() {
        if (this.FACTORY.revertToDefault()) {
            this.fireSettingsEvent(SettingsGroupEvent.EventType.REVERT_TO_DEFAULT);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Setting getSetting(String string) {
        SettingsFactory settingsFactory = this.FACTORY;
        synchronized (settingsFactory) {
            for (AbstractSetting abstractSetting : this.FACTORY) {
                if (!abstractSetting.getKey().equals(string)) continue;
                return abstractSetting;
            }
        }
        return null;
    }

    public String toString() {
        return this.FACTORY.toString();
    }
}

