/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.SynMessage;
import org.limewire.rudp.messages.impl.RUDPMessageImpl;

public class SynMessageImpl
extends RUDPMessageImpl
implements SynMessage {
    private final byte _senderConnectionID;
    private final short _protocolVersionNumber;

    SynMessageImpl(byte by) {
        super((byte)0, RUDPMessage.OpCode.OP_SYN, 0L, by, (short)0);
        this._senderConnectionID = by;
        this._protocolVersionNumber = 0;
    }

    SynMessageImpl(byte by, byte by2) {
        super(by2, RUDPMessage.OpCode.OP_SYN, 0L, by, (short)0);
        this._senderConnectionID = by;
        this._protocolVersionNumber = 0;
    }

    SynMessageImpl(byte by, long l, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws MessageFormatException {
        super(RUDPMessage.OpCode.OP_SYN, by, l, byteBuffer, byteBuffer2);
        if (byteBuffer.remaining() < 3) {
            throw new MessageFormatException("Message not long enough, message length " + byteBuffer.remaining() + " < 3");
        }
        this._senderConnectionID = byteBuffer.get();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this._protocolVersionNumber = byteBuffer.getShort();
        byteBuffer.rewind();
    }

    public byte getSenderConnectionID() {
        return this._senderConnectionID;
    }

    public int getProtocolVersionNumber() {
        return this._protocolVersionNumber;
    }

    public String toString() {
        return "SynMessage DestID:" + this.getConnectionID() + " SrcID:" + this._senderConnectionID + " vNo:" + this._protocolVersionNumber;
    }
}

