/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages;

import java.io.IOException;
import java.io.OutputStream;
import org.limewire.rudp.messages.MessageFormatException;

public interface RUDPMessage {
    public static final byte F_RUDP_MESSAGE = 65;
    public static final short PROTOCOL_VERSION_NUMBER = 0;

    public OpCode getOpCode();

    public void write(OutputStream var1) throws IOException;

    public byte getConnectionID();

    public long getSequenceNumber();

    public void extendSequenceNumber(long var1);

    public int getDataLength();

    public int getLength();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpCode {
        OP_SYN(0),
        OP_ACK(1),
        OP_KEEPALIVE(2),
        OP_DATA(3),
        OP_FIN(4);

        private int opcode;
        private static OpCode[] OPCODES;

        private OpCode(int n2) {
            this.opcode = n2;
        }

        public int toByte() {
            return this.opcode;
        }

        public String toString() {
            return this.name() + " (" + this.toByte() + ")";
        }

        public static OpCode valueOf(int n) throws MessageFormatException {
            OpCode opCode = OPCODES[n % OPCODES.length];
            if (opCode != null && opCode.opcode == n) {
                return opCode;
            }
            throw new MessageFormatException("Unknown opcode: " + n);
        }

        static {
            OpCode[] opCodeArray = OpCode.values();
            OPCODES = new OpCode[opCodeArray.length];
            for (OpCode opCode : opCodeArray) {
                int n = opCode.opcode % OPCODES.length;
                if (OPCODES[n] != null) {
                    throw new IllegalStateException("OpCode collision: index=" + n + ", OPCODES=" + (Object)((Object)OPCODES[n]) + ", o=" + (Object)((Object)opCode));
                }
                OpCode.OPCODES[n] = opCode;
            }
        }
    }
}

