/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.rudp.DataWindow;

public class WriteRegulator {
    private static final Log LOG = LogFactory.getLog(WriteRegulator.class);
    private static final int MIN_START_WINDOW = 40;
    private static final int LOW_WINDOW_SPACE = 4;
    private static final int MAX_SKIP_LIMIT = 14;
    private static final float LOW_FAILURE_RATE = 0.03f;
    private static final float HIGH_FAILURE_RATE = 0.04f;
    private DataWindow _sendWindow;
    private int _skipCount = 0;
    private int _skipLimit = 2;
    private boolean _limitHit = false;
    private int _limitCount = 0;
    private int _limitReset = 200;
    private int _zeroCount = 0;
    private FailureTracker _tracker;

    public WriteRegulator(DataWindow dataWindow) {
        this._sendWindow = dataWindow;
        this._tracker = new FailureTracker();
    }

    public void hitResendTimeout() {
        if ((!this._limitHit || this._limitCount >= 10) && this._tracker.failureRate() > 0.04f) {
            this._limitHit = true;
            this._skipLimit /= 2;
            this._limitCount = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("hitResendTimeout _skipLimit = " + this._skipLimit + " fR=" + this._tracker.failureRateAsString()));
            }
            this._tracker.clearOldFailures();
        }
    }

    public void hitZeroWindow() {
        ++this._zeroCount;
        if (!(this._limitHit && this._limitCount < 10 || this._zeroCount <= 4)) {
            this._zeroCount = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("hitZeroWindow _skipLimit = " + this._skipLimit + " fR=" + this._tracker.failureRateAsString()));
            }
        }
    }

    public long getSleepTime(long l, int n) {
        int n2;
        int n3 = this._sendWindow.getUsedSpots();
        int n4 = this._sendWindow.getWindowSize();
        long l2 = this._sendWindow.getWindowStart();
        int n5 = this._sendWindow.getRTO();
        float f = this._sendWindow.getRTTVar();
        float f2 = this._sendWindow.getSRTT();
        int n6 = n2 = (int)f2;
        int n7 = this._sendWindow.lowRoundTripTime();
        int n8 = n2;
        int n9 = n2;
        int n10 = n9 + 1;
        if (n10 == 0) {
            n10 = 10;
        }
        int n11 = Math.min(n6, 2000) / 4;
        int n12 = (n3 + 1) * n11;
        int n13 = 0;
        int n14 = 0;
        if (n12 < n4) {
            double d = (double)n12 / (double)n4;
            n12 = Math.random() < d ? 1 : 0;
        } else {
            n12 /= n4;
        }
        if (n <= 4) {
            int n15 = 4 / Math.max(1, n);
            n12 = (int)f2 * n15 / 5;
            if (n <= 2) {
                n12 = n5;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("LOW_WINDOW sT:" + n12));
                }
            }
            n13 = n12;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sleepTime:" + n12 + " uS:" + n3 + " RWS:" + n + " smoothRTT:" + n8 + " realRTT:" + n6 + " rtt:" + n10 + " RTO:" + n5 + " RTTVar:" + f + " srtt:" + f2 + " sL:" + this._skipLimit + " fR=" + this._tracker.failureRateAsString()));
        }
        if (this._skipLimit < 1) {
            this._skipLimit = 1;
        }
        int n16 = n8 > 5 * n7 / 2 ? n7 * 7 / 5 : n7 * 25 / 5;
        int n17 = n11 * n4 / this._skipLimit * 2 / 4;
        if (n10 != 0 && n11 != 0 && n <= 4 && (n17 < n10 || n10 > n16)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" -- MAX EXCEED  RTT sL:" + this._skipLimit + " w:" + l2 + " Rrtt:" + n6 + " base :" + n11 + " uS:" + n3 + " RWS:" + n + " lRTT:" + this._sendWindow.lowRoundTripTime() + " sWait:" + n9 + " mRTT:" + n16 + " wDelay:" + n17 + " sT:" + n12));
            }
            if (n10 > n16 || n6 > n16) {
                n13 = n7 / 4;
                if (n14 == 0) {
                    --this._skipLimit;
                }
                n14 = 50;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(" -- UP SLEEP  rtt:" + n10 + " mRTT:" + n16 + " rRTT:" + n6 + " lRTT:" + n7 + " sT:" + n12));
                }
            }
        }
        if (this._skipLimit < 1) {
            this._skipLimit = 1;
        }
        this._skipCount = (this._skipCount + 1) % this._skipLimit;
        if (!this._limitHit) {
            if (this._skipLimit < 14 && l2 % (long)n4 == 0L && n14 == 0 && l2 > 40L && this._tracker.failureRate() < 0.03f) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("up _skipLimit = " + this._skipLimit));
                }
                ++this._skipLimit;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(" -- UPP sL:" + this._skipLimit));
                }
            }
        } else {
            ++this._limitCount;
            if (this._limitCount >= this._limitReset) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(" -- UPP reset:" + this._skipLimit));
                }
                this._limitCount = 0;
                this._limitHit = false;
            }
        }
        if (this._skipCount != 0 && n10 < n16 && n > 4) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("_skipLimit = " + this._skipLimit));
            }
            n12 = 0;
        }
        n12 = Math.max(n12, n13);
        if (n14 > 0) {
            --n14;
        }
        return n12;
    }

    public void addMessageSuccess() {
        this._tracker.addSuccess();
    }

    public void addMessageFailure() {
        this._tracker.addFailure();
    }

    private class FailureTracker {
        private static final int HISTORY_SIZE = 100;
        private final byte[] _data = new byte[100];
        private boolean _rollover = false;
        private int _index;

        private FailureTracker() {
        }

        public void addSuccess() {
            this._data[this._index++] = 1;
            if (this._index >= 99) {
                LOG.debug((Object)"rolled over");
                this._index = 0;
                this._rollover = true;
            }
        }

        public void addFailure() {
            this._data[this._index++] = 0;
            if (this._index >= 99) {
                LOG.debug((Object)"rolled over");
                this._index = 0;
                this._rollover = true;
            }
        }

        public void clearOldFailures() {
            for (int i = 0; i < 50; ++i) {
                this.addSuccess();
            }
        }

        public float failureRate() {
            int n = 0;
            for (int i = 0; i < (this._rollover ? 100 : this._index); ++i) {
                n += this._data[i];
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("failure rate from " + this._index + " measurements and rollover " + this._rollover + " total is " + n + " and rate " + (1.0f - (float)n / (float)(this._rollover ? 100 : this._index))));
            }
            return 1.0f - (float)n / (float)(this._rollover ? 100 : this._index);
        }

        public String failureRateAsString() {
            float f = this.failureRate() * 1000.0f;
            int n = (int)f / 10;
            int n2 = (int)f - n * 10;
            return "" + n + "." + n2;
        }
    }
}

