/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import org.limewire.nio.observer.TransportListener;
import org.limewire.rudp.DefaultMessageDispatcher;
import org.limewire.rudp.DefaultRUDPSettings;
import org.limewire.rudp.DefaultUDPService;
import org.limewire.rudp.MessageDispatcher;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.RUDPSettings;
import org.limewire.rudp.UDPService;
import org.limewire.rudp.messages.RUDPMessageFactory;
import org.limewire.rudp.messages.impl.DefaultMessageFactory;

public class DefaultRUDPContext
implements RUDPContext {
    private final RUDPMessageFactory messageFactory;
    private final TransportListener transportListener;
    private final UDPService udpService;
    private final MessageDispatcher messageDispatcher;
    private final RUDPSettings rudpSettings;

    public DefaultRUDPContext() {
        this(new DefaultMessageFactory(), new NoOpTransportListener(), null, new DefaultMessageDispatcher(), new DefaultRUDPSettings());
    }

    public DefaultRUDPContext(RUDPMessageFactory rUDPMessageFactory) {
        this(rUDPMessageFactory, new NoOpTransportListener(), null, new DefaultMessageDispatcher(), new DefaultRUDPSettings());
    }

    public DefaultRUDPContext(TransportListener transportListener) {
        this(new DefaultMessageFactory(), transportListener, null, new DefaultMessageDispatcher(), new DefaultRUDPSettings());
    }

    public DefaultRUDPContext(UDPService uDPService) {
        this(new DefaultMessageFactory(), new NoOpTransportListener(), uDPService, null, new DefaultRUDPSettings());
    }

    public DefaultRUDPContext(RUDPSettings rUDPSettings) {
        this(new DefaultMessageFactory(), new NoOpTransportListener(), null, new DefaultMessageDispatcher(), rUDPSettings);
    }

    public DefaultRUDPContext(RUDPMessageFactory rUDPMessageFactory, TransportListener transportListener, UDPService uDPService, RUDPSettings rUDPSettings) {
        this(rUDPMessageFactory, transportListener, uDPService, null, rUDPSettings);
    }

    public DefaultRUDPContext(RUDPMessageFactory rUDPMessageFactory, TransportListener transportListener, UDPService uDPService, MessageDispatcher messageDispatcher, RUDPSettings rUDPSettings) {
        this.messageFactory = rUDPMessageFactory;
        this.transportListener = transportListener;
        this.udpService = uDPService == null ? new DefaultUDPService(messageDispatcher) : uDPService;
        this.messageDispatcher = messageDispatcher;
        this.rudpSettings = rUDPSettings;
    }

    public RUDPMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    public UDPService getUDPService() {
        return this.udpService;
    }

    public MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public RUDPSettings getRUDPSettings() {
        return this.rudpSettings;
    }

    private static final class NoOpTransportListener
    implements TransportListener {
        private NoOpTransportListener() {
        }

        public void eventPending() {
        }
    }
}

