/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.rudp.MessageDispatcher;
import org.limewire.rudp.UDPMultiplexor;
import org.limewire.rudp.messages.RUDPMessage;

public class DefaultMessageDispatcher
implements MessageDispatcher {
    private static final Log LOG = LogFactory.getLog(DefaultMessageDispatcher.class);
    private final Executor executor = ExecutorsHelper.newProcessingQueue((String)"RUDPDispatch");
    private volatile UDPMultiplexor multiplexor;

    void setUDPMultiplexor(UDPMultiplexor uDPMultiplexor) {
        if (this.multiplexor != null) {
            LOG.warn((Object)"Overriding old multiplexor!");
        }
        this.multiplexor = uDPMultiplexor;
    }

    public void dispatch(RUDPMessage rUDPMessage, InetSocketAddress inetSocketAddress) {
        this.executor.execute(new Dispatch(this.multiplexor, rUDPMessage, inetSocketAddress));
    }

    private static class Dispatch
    implements Runnable {
        private final UDPMultiplexor plexor;
        private final RUDPMessage msg;
        private final InetSocketAddress from;

        Dispatch(UDPMultiplexor uDPMultiplexor, RUDPMessage rUDPMessage, InetSocketAddress inetSocketAddress) {
            this.plexor = uDPMultiplexor;
            this.msg = rUDPMessage;
            this.from = inetSocketAddress;
        }

        public void run() {
            this.plexor.routeMessage(this.msg, this.from);
        }
    }
}

