/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.limewire.collection.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeAwareIterable<E>
implements Iterable<E> {
    private final int sampleSize;
    private final long maxTime;
    private final List<? extends E> elements;

    public TimeAwareIterable(long l, Collection<? extends E> collection) {
        this(10, l, collection);
    }

    public TimeAwareIterable(int n, long l, Collection<? extends E> collection) {
        this.sampleSize = n;
        this.maxTime = l;
        this.elements = CollectionUtils.toList(collection);
    }

    @Override
    public Iterator<E> iterator() {
        return new TimeAwareIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimeAwareIterator
    implements Iterator<E> {
        private final long[] samples;
        private int sampleCount;
        private int sampleIndex;
        private long startTime;
        private long lastTime;
        private int currentIndex;
        private int nextIndex;

        private TimeAwareIterator() {
            this.samples = new long[TimeAwareIterable.this.sampleSize];
            this.sampleCount = 0;
            this.sampleIndex = 0;
            this.startTime = -1L;
            this.lastTime = -1L;
            this.currentIndex = -1;
            this.nextIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIndex == -1 && this.nextIndex < TimeAwareIterable.this.elements.size()) {
                long l = System.currentTimeMillis();
                long l2 = 0L;
                if (this.startTime == -1L) {
                    this.startTime = l;
                }
                if (this.lastTime != -1L) {
                    l2 = this.addSample(l - this.lastTime);
                }
                this.lastTime = l;
                long l3 = TimeAwareIterable.this.maxTime - (l - this.startTime);
                if (l3 >= l2) {
                    this.currentIndex = this.nextIndex++;
                    int n = TimeAwareIterable.this.elements.size() - this.nextIndex;
                    assert (n >= 0);
                    this.nextIndex += (int)(l2 * (long)n / l3);
                }
            }
            return this.currentIndex != -1;
        }

        @Override
        public E next() {
            if (this.startTime == -1L || this.currentIndex == -1) {
                throw new NoSuchElementException();
            }
            int n = this.currentIndex;
            this.currentIndex = -1;
            return TimeAwareIterable.this.elements.get(n);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private long addSample(long l) {
            if (l >= 0L) {
                this.samples[this.sampleIndex] = l;
                this.sampleIndex = (this.sampleIndex + 1) % this.samples.length;
                if (this.sampleCount < this.samples.length) {
                    ++this.sampleCount;
                }
            }
            return this.getAverage();
        }

        private long getAverage() {
            if (this.sampleCount == 0) {
                return 0L;
            }
            long l = 0L;
            for (long l2 : this.samples) {
                l += l2;
            }
            return l / (long)this.sampleCount;
        }
    }
}

