/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntHashMap;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.RouteTableSettings;
import org.limewire.mojito.util.ContactUtils;

public class ClassfulNetworkCounter
implements Serializable {
    private static final long serialVersionUID = -6603762323364585225L;
    private static final Log LOG = LogFactory.getLog(ClassfulNetworkCounter.class);
    private final IntHashMap<AtomicInteger> nodesPerNetwork = new IntHashMap();
    private final Bucket bucket;

    public ClassfulNetworkCounter(Bucket bucket) {
        this.bucket = bucket;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public synchronized int get(Contact contact) {
        if (this.bucket.isLocalNode(contact)) {
            return 0;
        }
        if (!ContactUtils.isIPv4Address(contact)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(contact + " has not an IPv4 Address"));
            }
            return 0;
        }
        int n = ContactUtils.getClassC(contact);
        AtomicInteger atomicInteger = (AtomicInteger)this.nodesPerNetwork.get(n);
        if (atomicInteger != null) {
            return atomicInteger.get();
        }
        return 0;
    }

    public synchronized int incrementAndGet(Contact contact) {
        if (this.bucket.isLocalNode(contact)) {
            return 0;
        }
        if (!ContactUtils.isIPv4Address(contact)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(contact + " has not an IPv4 Address"));
            }
            return 0;
        }
        int n = ContactUtils.getClassC(contact);
        AtomicInteger atomicInteger = (AtomicInteger)this.nodesPerNetwork.get(n);
        if (atomicInteger == null) {
            assert (this.nodesPerNetwork.size() < this.bucket.getMaxActiveSize()) : this.nodesPerNetwork.size() + " < " + this.bucket.getMaxActiveSize() + contact + ", " + this.nodesPerNetwork + ", " + this.bucket;
            atomicInteger = new AtomicInteger(0);
            this.nodesPerNetwork.put(n, (Object)atomicInteger);
        }
        return atomicInteger.incrementAndGet();
    }

    public synchronized int decrementAndGet(Contact contact) {
        if (this.bucket.isLocalNode(contact)) {
            return 0;
        }
        if (!ContactUtils.isIPv4Address(contact)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(contact + " has not an IPv4 Address"));
            }
            return 0;
        }
        int n = ContactUtils.getClassC(contact);
        AtomicInteger atomicInteger = (AtomicInteger)this.nodesPerNetwork.get(n);
        if (atomicInteger != null) {
            int n2 = atomicInteger.decrementAndGet();
            if (n2 <= 0) {
                this.nodesPerNetwork.remove(n);
                assert (!this.nodesPerNetwork.containsKey(n));
            }
            return n2;
        }
        return 0;
    }

    public synchronized int size() {
        return this.nodesPerNetwork.size();
    }

    public synchronized void clear() {
        this.nodesPerNetwork.clear();
    }

    public synchronized boolean isOkayToAdd(Contact contact) {
        float f = this.get(contact);
        if (f == 0.0f) {
            return true;
        }
        assert (!this.bucket.isLocalNode(contact));
        assert (ContactUtils.isIPv4Address(contact));
        float f2 = RouteTableSettings.MAX_CONTACTS_PER_NETWORK_CLASS_RATIO.getValue();
        if (f2 >= 1.0f) {
            return true;
        }
        float f3 = this.bucket.getMaxActiveSize();
        float f4 = f / f3;
        return f4 < f2;
    }

    public synchronized String toString() {
        return this.nodesPerNetwork.toString();
    }
}

