/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.result;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.limewire.mojito.KUID;
import org.limewire.mojito.result.LookupResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNodeResult
extends LookupResult {
    private final Map<? extends Contact, ? extends SecurityToken> path;
    private final Collection<? extends Contact> collisions;
    private final Set<KUID> queried;
    private final long time;
    private final int hop;
    private final int routeTableFailureCount;

    public FindNodeResult(KUID kUID, Map<? extends Contact, ? extends SecurityToken> map, Collection<? extends Contact> collection, Set<KUID> set, long l, int n, int n2) {
        super(kUID);
        this.path = map;
        this.collisions = new CopyOnWriteArrayList<Contact>(collection);
        this.queried = new CopyOnWriteArraySet<KUID>(set);
        this.time = l;
        this.hop = n;
        this.routeTableFailureCount = n2;
    }

    @Override
    public Collection<? extends Contact> getPath() {
        return this.path.keySet();
    }

    @Override
    public SecurityToken getSecurityToken(Contact contact) {
        return this.path.get(contact);
    }

    @Override
    public Collection<? extends Map.Entry<? extends Contact, ? extends SecurityToken>> getEntryPath() {
        return this.path.entrySet();
    }

    public int getRouteTableFailureCount() {
        return this.routeTableFailureCount;
    }

    public Collection<? extends Contact> getCollisions() {
        return this.collisions;
    }

    public Set<KUID> getQueried() {
        return this.queried;
    }

    public long getTime() {
        return this.time;
    }

    public int getHop() {
        return this.hop;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLookupID()).append(" (time=").append(this.time).append("ms, hop=").append(this.hop).append(")\n");
        int n = 0;
        for (Map.Entry<? extends Contact, ? extends SecurityToken> object : this.path.entrySet()) {
            stringBuilder.append(n++).append(": ").append(object.getKey()).append(", token=").append(object.getValue()).append("\n");
        }
        if (!this.collisions.isEmpty()) {
            stringBuilder.append("Collisions:\n");
            n = 0;
            for (Contact contact : this.collisions) {
                stringBuilder.append(n++).append(": ").append(contact).append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

