/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.impl.AbstractLookupResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindValueResponseImpl
extends AbstractLookupResponse
implements FindValueResponse {
    private final Collection<KUID> secondaryKeys;
    private final Collection<? extends DHTValueEntity> entities;
    private final float requestLoad;

    public FindValueResponseImpl(Context context, Contact contact, MessageID messageID, float f, Collection<? extends DHTValueEntity> collection, Collection<KUID> collection2) {
        super(context, DHTMessage.OpCode.FIND_VALUE_RESPONSE, contact, messageID, Version.ZERO);
        this.requestLoad = f;
        this.entities = collection;
        this.secondaryKeys = collection2;
    }

    public FindValueResponseImpl(Context context, SocketAddress socketAddress, MessageID messageID, Version version, MessageInputStream messageInputStream) throws IOException {
        super(context, DHTMessage.OpCode.FIND_VALUE_RESPONSE, socketAddress, messageID, version, messageInputStream);
        this.requestLoad = messageInputStream.readFloat();
        this.entities = messageInputStream.readDHTValueEntities(this.getContact(), context.getDHTValueFactoryManager());
        this.secondaryKeys = messageInputStream.readKUIDs();
    }

    @Override
    public Collection<KUID> getSecondaryKeys() {
        return this.secondaryKeys;
    }

    @Override
    public Collection<? extends DHTValueEntity> getDHTValueEntities() {
        return this.entities;
    }

    @Override
    public float getRequestLoad() {
        return this.requestLoad;
    }

    @Override
    protected void writeBody(MessageOutputStream messageOutputStream) throws IOException {
        messageOutputStream.writeFloat(this.requestLoad);
        messageOutputStream.writeDHTValueEntities(this.entities);
        messageOutputStream.writeKUIDs(this.secondaryKeys);
    }

    public String toString() {
        return "FindValueResponse: " + this.entities;
    }
}

