/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages;

import org.limewire.mojito.messages.DHTSecureMessage;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.messages.RequestMessage;

public interface StatsRequest
extends RequestMessage,
DHTSecureMessage {
    public StatisticType getType();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatisticType {
        STATISTICS(1),
        DATABASE(2),
        ROUTETABLE(3);

        private int type;
        private static final StatisticType[] TYPES;

        private StatisticType(int n2) {
            this.type = n2;
        }

        public int toByte() {
            return this.type;
        }

        public String toString() {
            return this.name() + " (" + this.toByte() + ")";
        }

        public static StatisticType valueOf(int n) throws MessageFormatException {
            int n2 = n % TYPES.length;
            StatisticType statisticType = TYPES[n2];
            if (statisticType.type == n) {
                return statisticType;
            }
            throw new MessageFormatException("Unknown type: " + n);
        }

        static {
            StatisticType[] statisticTypeArray = StatisticType.values();
            TYPES = new StatisticType[statisticTypeArray.length];
            for (StatisticType statisticType : statisticTypeArray) {
                int n = statisticType.type % TYPES.length;
                if (TYPES[n] != null) {
                    throw new IllegalStateException("Type collision: index=" + n + ", TYPE=" + (Object)((Object)TYPES[n]) + ", t=" + (Object)((Object)statisticType));
                }
                StatisticType.TYPES[n] = statisticType;
            }
        }
    }
}

