/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.concurrent.DHTValueFuture;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.exceptions.DHTBackendException;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.handler.response.FindNodeResponseHandler;
import org.limewire.mojito.handler.response.FindValueResponseHandler;
import org.limewire.mojito.handler.response.LookupResponseHandler;
import org.limewire.mojito.handler.response.StoreResponseHandler;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.SecurityTokenProvider;
import org.limewire.mojito.result.LookupResult;
import org.limewire.mojito.result.Result;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.LookupSettings;
import org.limewire.mojito.settings.StoreSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.ContactsScrubber;
import org.limewire.mojito.util.EntityUtils;
import org.limewire.mojito.util.EntryImpl;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StoreProcess
implements DHTTask<StoreResult> {
    private final Context context;
    private final List<DHTTask<?>> tasks = new ArrayList();
    private boolean cancelled = false;
    private DHTFuture<StoreResult> future;
    private final KUID primaryKey;
    private final Map.Entry<? extends Contact, ? extends SecurityToken> node;
    private final Collection<? extends DHTValueEntity> entities;
    private final long waitOnLock;

    public StoreProcess(Context context, Collection<? extends DHTValueEntity> collection) {
        this(context, null, collection);
    }

    public StoreProcess(Context context, Map.Entry<? extends Contact, ? extends SecurityToken> entry, Collection<? extends DHTValueEntity> collection) {
        this.context = context;
        this.entities = collection;
        this.node = entry;
        if (entry != null && entry.getKey() == null) {
            throw new IllegalArgumentException("Contact is null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("No Values to store");
        }
        if (entry == null) {
            this.primaryKey = EntityUtils.getPrimaryKey(collection);
            if (this.primaryKey == null) {
                throw new IllegalArgumentException("All DHTValues must have the same primary key");
            }
        } else {
            this.primaryKey = null;
        }
        this.waitOnLock = StoreSettings.getWaitOnLock(entry != null);
    }

    @Override
    public long getWaitOnLockTimeout() {
        return this.waitOnLock;
    }

    @Override
    public void start(DHTFuture<StoreResult> dHTFuture) {
        this.future = dHTFuture;
        if (this.node == null) {
            this.findNearestNodes();
        } else if (this.node.getValue() == null && StoreSettings.STORE_REQUIRES_SECURITY_TOKEN.getValue()) {
            this.doGetSecurityToken();
        } else {
            this.doStoreOnPath(Collections.singleton(this.node));
        }
    }

    private void findNearestNodes() {
        DHTValueFuture<LookupResult> dHTValueFuture = new DHTValueFuture<LookupResult>(){

            public synchronized boolean setValue(LookupResult lookupResult) {
                if (super.setValue((Object)lookupResult)) {
                    StoreProcess.this.handleNearestNodes(lookupResult);
                    return true;
                }
                return false;
            }

            public synchronized boolean setException(Throwable throwable) {
                if (super.setException(throwable)) {
                    StoreProcess.this.future.setException(throwable);
                    return true;
                }
                return false;
            }
        };
        LookupResponseHandler<LookupResult> lookupResponseHandler = this.createLookupResponseHandler();
        lookupResponseHandler.setSelectAliveNodesOnly(true);
        this.start(lookupResponseHandler, dHTValueFuture);
    }

    private void handleNearestNodes(LookupResult lookupResult) {
        this.doStoreOnPath(lookupResult.getEntryPath());
    }

    private void doGetSecurityToken() {
        DHTValueFuture<GetSecurityTokenResult> dHTValueFuture = new DHTValueFuture<GetSecurityTokenResult>(){

            public synchronized boolean setValue(GetSecurityTokenResult getSecurityTokenResult) {
                if (super.setValue((Object)getSecurityTokenResult)) {
                    StoreProcess.this.handleSecurityToken(getSecurityTokenResult);
                    return true;
                }
                return false;
            }

            public synchronized boolean setException(Throwable throwable) {
                if (super.setException(throwable)) {
                    StoreProcess.this.future.setException(throwable);
                    return true;
                }
                return false;
            }
        };
        GetSecurityTokenHandler getSecurityTokenHandler = new GetSecurityTokenHandler(this.context, this.node.getKey());
        this.start(getSecurityTokenHandler, dHTValueFuture);
    }

    private void handleSecurityToken(GetSecurityTokenResult getSecurityTokenResult) {
        SecurityToken securityToken = getSecurityTokenResult.getSecurityToken();
        if (securityToken == null) {
            this.future.setException(new ExecutionException(new DHTException("Could not get SecurityToken from " + this.node)));
        } else {
            EntryImpl<Contact, SecurityToken> entryImpl = new EntryImpl<Contact, SecurityToken>(this.node.getKey(), securityToken);
            this.doStoreOnPath(Collections.singleton(entryImpl));
        }
    }

    private void doStoreOnPath(Collection<? extends Map.Entry<? extends Contact, ? extends SecurityToken>> collection) {
        StoreResponseHandler storeResponseHandler = new StoreResponseHandler(this.context, collection, this.entities);
        this.start(storeResponseHandler, this.future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void start(DHTTask<T> dHTTask, DHTFuture<T> dHTFuture) {
        boolean bl = false;
        List<DHTTask<?>> list = this.tasks;
        synchronized (list) {
            if (!this.cancelled) {
                this.tasks.add(dHTTask);
                bl = true;
            }
        }
        if (bl) {
            dHTTask.start(dHTFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ArrayList arrayList = null;
        List<DHTTask<?>> list = this.tasks;
        synchronized (list) {
            if (!this.cancelled) {
                arrayList = new ArrayList(this.tasks);
                this.tasks.clear();
                this.cancelled = true;
            }
        }
        if (arrayList != null) {
            for (DHTTask dHTTask : arrayList) {
                dHTTask.cancel();
            }
        }
    }

    private LookupResponseHandler<LookupResult> createLookupResponseHandler() {
        LookupResponseHandler lookupResponseHandler = null;
        if (LookupSettings.FIND_NODE_FOR_SECURITY_TOKEN.getValue()) {
            lookupResponseHandler = new FindNodeResponseHandler(this.context, this.primaryKey);
        } else {
            EntityKey entityKey = EntityKey.createEntityKey(this.primaryKey, DHTValueType.ANY);
            lookupResponseHandler = new FindValueResponseHandler(this.context, entityKey);
        }
        return lookupResponseHandler;
    }

    private static class GetSecurityTokenResult
    implements Result {
        private final SecurityToken securityToken;

        public GetSecurityTokenResult(SecurityToken securityToken) {
            this.securityToken = securityToken;
        }

        public SecurityToken getSecurityToken() {
            return this.securityToken;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetSecurityTokenHandler
    extends AbstractResponseHandler<GetSecurityTokenResult> {
        private static final Log LOG = LogFactory.getLog(GetSecurityTokenHandler.class);
        private final Contact node;

        private GetSecurityTokenHandler(Context context, Contact contact) {
            super(context);
            this.node = contact;
        }

        @Override
        protected void start() throws DHTException {
            RequestMessage requestMessage = this.createLookupRequest();
            try {
                this.context.getMessageDispatcher().send(this.node, requestMessage, (ResponseHandler)this);
            }
            catch (IOException iOException) {
                throw new DHTException(iOException);
            }
        }

        private RequestMessage createLookupRequest() {
            if (LookupSettings.FIND_NODE_FOR_SECURITY_TOKEN.getValue()) {
                return this.context.getMessageHelper().createFindNodeRequest(this.node.getContactAddress(), this.node.getNodeID());
            }
            Set<KUID> set = Collections.emptySet();
            return this.context.getMessageHelper().createFindValueRequest(this.node.getContactAddress(), this.node.getNodeID(), set, DHTValueType.ANY);
        }

        @Override
        protected void response(ResponseMessage responseMessage, long l) throws IOException {
            FindNodeResponse findNodeResponse;
            if (responseMessage instanceof FindNodeResponse) {
                ContactsScrubber contactsScrubber;
                findNodeResponse = (FindNodeResponse)responseMessage;
                Contact contact = findNodeResponse.getContact();
                Collection<? extends Contact> collection = findNodeResponse.getNodes();
                if (!collection.isEmpty() && (contactsScrubber = ContactsScrubber.scrub(this.context, contact, collection, LookupSettings.CONTACTS_SCRUBBER_REQUIRED_RATIO.getValue())).isValidResponse()) {
                    for (Contact contact2 : contactsScrubber.getScrubbed()) {
                        assert (!contact2.isAlive());
                        this.context.getRouteTable().add(contact2);
                    }
                }
            }
            findNodeResponse = null;
            if (responseMessage instanceof SecurityTokenProvider) {
                findNodeResponse = ((SecurityTokenProvider)((Object)responseMessage)).getSecurityToken();
            }
            this.setReturnValue(new GetSecurityTokenResult((SecurityToken)findNodeResponse));
        }

        @Override
        protected void timeout(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) throws IOException {
            this.fireTimeoutException(kUID, socketAddress, requestMessage, l);
        }

        @Override
        protected void error(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, IOException iOException) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Getting the SecurityToken from " + ContactUtils.toString(kUID, socketAddress) + " failed"), (Throwable)iOException);
            }
            this.setException(new DHTBackendException(kUID, socketAddress, requestMessage, iOException));
        }
    }
}

