/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTValueFuture;
import org.limewire.mojito.handler.response.FindNodeResponseHandler;
import org.limewire.mojito.manager.BootstrapProcess;
import org.limewire.mojito.result.FindNodeResult;

class BootstrapWorker
implements Runnable {
    private static final Log LOG = LogFactory.getLog(BootstrapWorker.class);
    private final BootstrapProcess process;
    private final Context context;
    private volatile DHTFuture<FindNodeResult> exchanger;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    BootstrapWorker(Context context, BootstrapProcess bootstrapProcess) {
        this.process = bootstrapProcess;
        this.context = context;
    }

    public void run() {
        LOG.debug((Object)"starting worker");
        while (!this.shutdown.get()) {
            KUID kUID = this.process.getNextBucket();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this + " will refresh " + kUID));
            }
            if (kUID == null) {
                return;
            }
            this.refreshBucket(kUID);
        }
    }

    private void refreshBucket(KUID kUID) {
        DHTValueFuture<FindNodeResult> dHTValueFuture = new DHTValueFuture<FindNodeResult>();
        FindNodeResponseHandler findNodeResponseHandler = new FindNodeResponseHandler(this.context, kUID);
        findNodeResponseHandler.start(dHTValueFuture);
        this.exchanger = dHTValueFuture;
        FindNodeResult findNodeResult = null;
        try {
            findNodeResult = (FindNodeResult)dHTValueFuture.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancellationException cancellationException) {
            if (!this.shutdown.get()) {
                throw new IllegalStateException(cancellationException);
            }
        }
        catch (ExecutionException executionException) {
            LOG.info((Object)"ExecutionException", (Throwable)executionException);
            this.process.handleExecutionException(executionException);
        }
        if (findNodeResult == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Finished Bucket refresh: " + findNodeResult));
        }
        this.process.refreshDone(findNodeResult.getRouteTableFailureCount(), !findNodeResult.getPath().isEmpty());
    }

    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        DHTFuture<FindNodeResult> dHTFuture = this.exchanger;
        if (dHTFuture != null) {
            dHTFuture.cancel(true);
        }
    }
}

