/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.KUID;
import org.limewire.mojito.StatusCode;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageOutputStream
extends DataOutputStream {
    public MessageOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeKUID(KUID kUID) throws IOException {
        if (kUID == null) {
            throw new NullPointerException("KUID cannot be null");
        }
        kUID.write(this);
    }

    public void writeMessageID(MessageID messageID) throws IOException {
        if (messageID == null) {
            throw new NullPointerException("MessageID cannot be null");
        }
        messageID.write(this);
    }

    public void writeDHTSize(BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 20) {
            throw new IOException("Illegal length: " + byArray.length + "/" + bigInteger);
        }
        this.writeByte(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writeDHTValueEntity(DHTValueEntity dHTValueEntity) throws IOException {
        this.writeContact(dHTValueEntity.getCreator());
        dHTValueEntity.getPrimaryKey().write(this);
        this.writeDHTValue(dHTValueEntity.getValue());
    }

    private void writeDHTValue(DHTValue dHTValue) throws IOException {
        this.writeDHTValueType(dHTValue.getValueType());
        this.writeVersion(dHTValue.getVersion());
        byte[] byArray = dHTValue.getValue();
        this.writeShort(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writeKUIDs(Collection<KUID> collection) throws IOException {
        this.writeCollectionSize(collection);
        for (KUID kUID : collection) {
            kUID.write(this);
        }
    }

    public void writeDHTValueEntities(Collection<? extends DHTValueEntity> collection) throws IOException {
        this.writeCollectionSize(collection);
        for (DHTValueEntity dHTValueEntity : collection) {
            this.writeDHTValueEntity(dHTValueEntity);
        }
    }

    public void writeSignature(byte[] byArray) throws IOException {
        if (byArray != null && byArray.length > 0) {
            this.writeByte(byArray.length);
            this.write(byArray, 0, byArray.length);
        } else {
            this.writeByte(0);
        }
    }

    public void writeContact(Contact contact) throws IOException {
        this.writeVendor(contact.getVendor());
        this.writeVersion(contact.getVersion());
        this.writeKUID(contact.getNodeID());
        this.writeSocketAddress(contact.getContactAddress());
    }

    public void writeContacts(Collection<? extends Contact> collection) throws IOException {
        this.writeCollectionSize(collection);
        for (Contact contact : collection) {
            this.writeContact(contact);
        }
    }

    public void writeInetAddress(InetAddress inetAddress) throws IOException {
        byte[] byArray = inetAddress.getAddress();
        this.writeByte(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writePort(int n) throws IOException {
        this.writeShort(n);
    }

    public void writeSocketAddress(SocketAddress socketAddress) throws IOException {
        if (socketAddress instanceof InetSocketAddress && !((InetSocketAddress)socketAddress).isUnresolved()) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            this.writeInetAddress(inetSocketAddress.getAddress());
            this.writePort(inetSocketAddress.getPort());
        } else {
            this.writeByte(0);
        }
    }

    public void writeSecurityToken(SecurityToken securityToken) throws IOException {
        if (securityToken != null) {
            assert (securityToken instanceof AddressSecurityToken);
            byte[] byArray = securityToken.getBytes();
            this.writeByte(byArray.length);
            this.write(byArray, 0, byArray.length);
        } else {
            this.writeByte(0);
        }
    }

    public void writeStatistics(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.writeShort(byArray.length);
            this.write(byArray);
        } else {
            this.writeShort(0);
        }
    }

    public void writeOpCode(DHTMessage.OpCode opCode) throws IOException {
        this.writeByte(opCode.toByte());
    }

    public void writeStatisticType(StatsRequest.StatisticType statisticType) throws IOException {
        this.writeByte(statisticType.toByte());
    }

    public void writeStatusCode(StatusCode statusCode) throws IOException {
        this.writeShort(statusCode.shortValue());
        this.writeDHTString(statusCode.getDescription());
    }

    void writeDHTString(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        if (byArray.length > 65535) {
            throw new IOException("String is too big");
        }
        this.writeShort(byArray.length);
        this.write(byArray);
    }

    public void writeStoreStatusCodes(Collection<StoreResponse.StoreStatusCode> collection) throws IOException {
        this.writeCollectionSize(collection);
        for (StoreResponse.StoreStatusCode storeStatusCode : collection) {
            this.writeKUID(storeStatusCode.getPrimaryKey());
            this.writeKUID(storeStatusCode.getSecondaryKey());
            this.writeStatusCode(storeStatusCode.getStatusCode());
        }
    }

    private void writeCollectionSize(Collection collection) throws IOException {
        int n = collection.size();
        if (n > 255) {
            throw new IOException("Too many elements: " + n);
        }
        this.writeByte(n);
    }

    public void writeDHTValueType(DHTValueType dHTValueType) throws IOException {
        this.writeInt(dHTValueType.toInt());
    }

    public void writeVendor(Vendor vendor) throws IOException {
        this.writeInt(vendor.intValue());
    }

    public void writeVersion(Version version) throws IOException {
        this.writeShort(version.shortValue());
    }
}

