/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.KUID;
import org.limewire.mojito.StatusCode;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueFactoryManager;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.messages.impl.DefaultMessageID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.ContactFactory;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageInputStream
extends DataInputStream {
    private final MACCalculatorRepositoryManager MACCalculatorRepositoryManager;

    public MessageInputStream(InputStream inputStream, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        super(inputStream);
        this.MACCalculatorRepositoryManager = mACCalculatorRepositoryManager;
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public KUID readKUID() throws IOException {
        return KUID.createWithInputStream(this);
    }

    public MessageID readMessageID() throws IOException {
        return DefaultMessageID.createWithInputStream(this, this.MACCalculatorRepositoryManager);
    }

    public BigInteger readDHTSize() throws IOException {
        int n = this.readUnsignedByte();
        if (n > 20) {
            throw new IOException("Illegal length: " + n);
        }
        byte[] byArray = this.readBytes(n);
        return new BigInteger(1, byArray);
    }

    public DHTValueEntity readDHTValueEntity(Contact contact, DHTValueFactoryManager dHTValueFactoryManager) throws IOException {
        Contact contact2 = this.readContact();
        KUID kUID = this.readKUID();
        DHTValue dHTValue = this.readDHTValue(dHTValueFactoryManager);
        if (contact2.getNodeID().equals(contact.getNodeID())) {
            contact2 = contact;
        }
        return DHTValueEntity.createFromRemote(contact2, contact, kUID, dHTValue);
    }

    private DHTValue readDHTValue(DHTValueFactoryManager dHTValueFactoryManager) throws IOException {
        DHTValueType dHTValueType = this.readValueType();
        Version version = this.readVersion();
        byte[] byArray = null;
        int n = this.readUnsignedShort();
        if (n > 0) {
            byArray = new byte[n];
            this.readFully(byArray);
        }
        return dHTValueFactoryManager.createDHTValue(dHTValueType, version, byArray);
    }

    public List<DHTValueEntity> readDHTValueEntities(Contact contact, DHTValueFactoryManager dHTValueFactoryManager) throws IOException {
        int n = this.readUnsignedByte();
        if (n == 0) {
            return Collections.emptyList();
        }
        DHTValueEntity[] dHTValueEntityArray = new DHTValueEntity[n];
        for (int i = 0; i < dHTValueEntityArray.length; ++i) {
            dHTValueEntityArray[i] = this.readDHTValueEntity(contact, dHTValueFactoryManager);
        }
        return Arrays.asList(dHTValueEntityArray);
    }

    public Collection<KUID> readKUIDs() throws IOException {
        int n = this.readUnsignedByte();
        if (n == 0) {
            return Collections.emptySet();
        }
        KUID[] kUIDArray = new KUID[n];
        for (int i = 0; i < n; ++i) {
            kUIDArray[i] = this.readKUID();
        }
        return Arrays.asList(kUIDArray);
    }

    public byte[] readSignature() throws IOException {
        int n = this.readUnsignedByte();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, byArray.length);
        return byArray;
    }

    public Contact readContact() throws IOException {
        Vendor vendor = this.readVendor();
        Version version = this.readVersion();
        KUID kUID = this.readKUID();
        InetSocketAddress inetSocketAddress = this.readSocketAddress();
        if (inetSocketAddress == null) {
            throw new UnknownHostException("SocketAddress is " + inetSocketAddress);
        }
        return ContactFactory.createUnknownContact(vendor, version, kUID, inetSocketAddress);
    }

    public Collection<Contact> readContacts() throws IOException {
        int n = this.readUnsignedByte();
        if (n == 0) {
            return Collections.emptyList();
        }
        Contact[] contactArray = new Contact[n];
        for (int i = 0; i < contactArray.length; ++i) {
            contactArray[i] = this.readContact();
        }
        return Arrays.asList(contactArray);
    }

    public InetAddress readInetAddress() throws IOException {
        int n = this.readUnsignedByte();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return InetAddress.getByAddress(byArray);
    }

    public int readPort() throws IOException {
        return this.readUnsignedShort();
    }

    public InetSocketAddress readSocketAddress() throws IOException {
        InetAddress inetAddress = this.readInetAddress();
        if (inetAddress == null || !NetworkUtils.isValidAddress((InetAddress)inetAddress)) {
            return null;
        }
        int n = this.readPort();
        return new InetSocketAddress(inetAddress, n);
    }

    public SecurityToken readSecurityToken() throws IOException {
        int n = this.readUnsignedByte();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, byArray.length);
        return new AddressSecurityToken(byArray, this.MACCalculatorRepositoryManager);
    }

    public byte[] readStatistics() throws IOException {
        int n = this.readUnsignedShort();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public DHTMessage.OpCode readOpCode() throws IOException {
        return DHTMessage.OpCode.valueOf(this.readUnsignedByte());
    }

    public StatsRequest.StatisticType readStatisticType() throws IOException {
        return StatsRequest.StatisticType.valueOf(this.readUnsignedByte());
    }

    public StatusCode readStatusCode() throws IOException {
        return StatusCode.valueOf(this.readUnsignedShort(), this.readDHTString());
    }

    private String readDHTString() throws IOException {
        int n = this.readUnsignedShort();
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return new String(byArray, "UTF-8");
    }

    public Collection<StoreResponse.StoreStatusCode> readStoreStatusCodes() throws IOException {
        int n = this.readUnsignedByte();
        if (n == 0) {
            return Collections.emptySet();
        }
        StoreResponse.StoreStatusCode[] storeStatusCodeArray = new StoreResponse.StoreStatusCode[n];
        for (int i = 0; i < n; ++i) {
            KUID kUID = this.readKUID();
            KUID kUID2 = this.readKUID();
            StatusCode statusCode = this.readStatusCode();
            storeStatusCodeArray[i] = new StoreResponse.StoreStatusCode(kUID, kUID2, statusCode);
        }
        return Arrays.asList(storeStatusCodeArray);
    }

    public DHTValueType readValueType() throws IOException {
        return DHTValueType.valueOf(this.readInt());
    }

    public Vendor readVendor() throws IOException {
        return Vendor.valueOf(this.readInt());
    }

    public Version readVersion() throws IOException {
        return Version.valueOf(this.readUnsignedShort());
    }
}

