/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.exceptions.DHTBackendException;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.exceptions.DHTNoSuchElementException;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.util.DatabaseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetValueResponseHandler
extends AbstractResponseHandler<FindValueResult> {
    private static final Log LOG = LogFactory.getLog(GetValueResponseHandler.class);
    private final EntityKey lookupKey;

    public GetValueResponseHandler(Context context, EntityKey entityKey) {
        super(context);
        this.lookupKey = entityKey;
    }

    @Override
    protected void start() throws DHTException {
        Contact contact = this.lookupKey.getContact();
        KUID kUID = this.lookupKey.getPrimaryKey();
        KUID kUID2 = this.lookupKey.getSecondaryKey();
        DHTValueType dHTValueType = this.lookupKey.getDHTValueType();
        FindValueRequest findValueRequest = this.context.getMessageHelper().createFindValueRequest(contact.getContactAddress(), kUID, Collections.singleton(kUID2), dHTValueType);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("start looking for: " + findValueRequest));
        }
        try {
            this.context.getMessageDispatcher().send(contact, (RequestMessage)findValueRequest, (ResponseHandler)this);
        }
        catch (IOException iOException) {
            throw new DHTException(iOException);
        }
    }

    @Override
    protected void response(ResponseMessage responseMessage, long l) throws IOException {
        if (responseMessage instanceof FindValueResponse) {
            FindValueResponse findValueResponse = (FindValueResponse)responseMessage;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("received response: " + findValueResponse));
            }
            Collection<? extends DHTValueEntity> collection = DatabaseUtils.filter(this.lookupKey.getDHTValueType(), findValueResponse.getDHTValueEntities());
            Map map = Collections.emptyMap();
            Set set = Collections.emptySet();
            FindValueResult findValueResult = new FindValueResult(this.lookupKey, map, collection, set, l, 1);
            this.setReturnValue(findValueResult);
        } else {
            this.setException(new DHTNoSuchElementException(responseMessage, this.lookupKey.toString()));
        }
    }

    @Override
    protected void timeout(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) throws IOException {
        this.fireTimeoutException(kUID, socketAddress, requestMessage, l);
    }

    @Override
    protected void error(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, IOException iOException) {
        this.setException(new DHTBackendException(kUID, socketAddress, requestMessage, iOException));
    }
}

