/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.handler.response.LookupResponseHandler;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.LookupRequest;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.result.FindNodeResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.LookupSettings;
import org.limewire.mojito.statistics.FindNodeLookupStatisticContainer;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNodeResponseHandler
extends LookupResponseHandler<FindNodeResult> {
    private FindNodeLookupStatisticContainer lookupStat;

    public FindNodeResponseHandler(Context context, KUID kUID) {
        super(context, kUID);
        this.init();
    }

    public FindNodeResponseHandler(Context context, Contact contact, KUID kUID) {
        super(context, kUID);
        this.addForcedContact(contact);
        this.init();
    }

    public FindNodeResponseHandler(Context context, KUID kUID, int n) {
        super(context, kUID);
        this.setResultSetSize(n);
        this.init();
    }

    public FindNodeResponseHandler(Context context, Contact contact, KUID kUID, int n) {
        super(context, kUID);
        this.addForcedContact(contact);
        this.setResultSetSize(n);
        this.init();
    }

    private void init() {
        this.lookupStat = new FindNodeLookupStatisticContainer(this.context, this.getLookupID());
    }

    @Override
    protected void response(ResponseMessage responseMessage, long l) throws IOException {
        super.response(responseMessage, l);
        this.lookupStat.addReply();
    }

    @Override
    protected void timeout(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) throws IOException {
        super.timeout(kUID, socketAddress, requestMessage, l);
        this.lookupStat.addTimeout();
    }

    @Override
    protected boolean lookup(Contact contact) throws IOException {
        if (super.lookup(contact)) {
            this.lookupStat.addRequest();
            return true;
        }
        return false;
    }

    @Override
    protected void finishLookup() {
        long l = this.getElapsedTime();
        int n = this.getRouteTableFailureCount();
        int n2 = this.getCurrentHop();
        this.lookupStat.setHops(n2, false);
        this.lookupStat.setTime((int)l, false);
        Map<Contact, SecurityToken> map = this.getPath();
        Collection<Contact> collection = this.getCollisions();
        Set<KUID> set = this.getQueried();
        FindNodeResult findNodeResult = new FindNodeResult(this.getLookupID(), map, collection, set, l, n2, n);
        this.context.updateEstimatedSize(map.keySet());
        this.setReturnValue(findNodeResult);
    }

    public Collection<Contact> getCollisions() {
        return this.collisions;
    }

    @Override
    protected int getDefaultParallelism() {
        return LookupSettings.FIND_NODE_PARALLEL_LOOKUPS.getValue();
    }

    @Override
    protected boolean isTimeout(long l) {
        long l2 = LookupSettings.FIND_NODE_LOOKUP_TIMEOUT.getValue();
        return l2 > 0L && l >= l2;
    }

    @Override
    protected LookupRequest createLookupRequest(Contact contact) {
        return this.context.getMessageHelper().createFindNodeRequest(contact.getContactAddress(), this.lookupId);
    }

    @Override
    protected boolean nextStep(ResponseMessage responseMessage) throws IOException {
        if (!(responseMessage instanceof FindNodeResponse)) {
            throw new IllegalArgumentException("this is find node handler");
        }
        return this.handleNodeResponse((FindNodeResponse)responseMessage);
    }
}

