/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler;

import java.net.SocketAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.CollectionUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.SecurityTokenProvider;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.DatabaseSettings;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.settings.StoreSettings;
import org.limewire.mojito.statistics.DatabaseStatisticContainer;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageHandler {
    private static final Log LOG = LogFactory.getLog(DefaultMessageHandler.class);
    private DatabaseStatisticContainer databaseStats;
    protected final Context context;

    public DefaultMessageHandler(Context context) {
        this.context = context;
        this.databaseStats = context.getDatabaseStats();
    }

    public void handleResponse(ResponseMessage responseMessage, long l) {
        this.addLiveContactInfo(responseMessage.getContact(), responseMessage);
    }

    public void handleLateResponse(ResponseMessage responseMessage) {
        Contact contact = responseMessage.getContact();
        if (!contact.isFirewalled()) {
            this.context.getRouteTable().add(contact);
        }
    }

    public void handleTimeout(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) {
        this.context.getRouteTable().handleFailure(kUID, socketAddress);
    }

    public void handleRequest(RequestMessage requestMessage) {
        this.addLiveContactInfo(requestMessage.getContact(), requestMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addLiveContactInfo(Contact contact, DHTMessage dHTMessage) {
        int n;
        Collection<Contact> collection;
        Contact contact2;
        RouteTable routeTable = this.context.getRouteTable();
        if (contact.isShutdown()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(contact + " is going to shut down"));
            }
            RouteTable routeTable2 = routeTable;
            synchronized (routeTable2) {
                Contact contact3 = routeTable.get(contact.getNodeID());
                if (contact.equals(contact3)) {
                    if (contact3.isAlive()) {
                        contact3.shutdown(true);
                    }
                    routeTable.add(contact);
                    contact.shutdown(true);
                }
            }
            return;
        }
        if (contact.isFirewalled()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(contact + " is firewalled"));
            }
            return;
        }
        if (ContactUtils.isPrivateAddress(contact)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(contact + " has a private address"));
            }
            return;
        }
        KUID kUID = contact.getNodeID();
        if (this.context.isLocalNodeID(kUID)) {
            assert (dHTMessage instanceof PingResponse) : "Expected a PingResponse but got a " + dHTMessage.getClass() + " from " + dHTMessage.getContact();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Looks like our NodeID collides with " + contact));
            }
            return;
        }
        if (StoreSettings.STORE_FORWARD_ENABLED.getValue() && ((contact2 = routeTable.get(kUID)) == null || contact2.isDead() || contact2.getInstanceID() != contact.getInstanceID()) && this.context.isBootstrapped() && this.containsNodeID(collection = routeTable.select(kUID, 2 * (n = KademliaSettings.REPLICATION_PARAMETER.getValue()), RouteTable.SelectMode.ALL), this.context.getLocalNodeID())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Node " + contact + " is new or has changed his instanceID, will check for store forward!"));
            }
            this.forwardOrRemoveValues(contact, contact2, dHTMessage);
        }
        routeTable.add(contact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardOrRemoveValues(Contact contact, Contact contact2, DHTMessage dHTMessage) {
        Database database;
        ArrayList<DHTValueEntity> arrayList = new ArrayList<DHTValueEntity>();
        Database database2 = database = this.context.getDatabase();
        synchronized (database2) {
            for (KUID kUID : database.keySet()) {
                Map<KUID, DHTValueEntity> map;
                Operation operation = this.getOperation(contact, contact2, kUID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("node: " + contact + "existing: " + contact2 + "operation: " + (Object)((Object)operation)));
                }
                if (operation.equals((Object)Operation.FORWARD)) {
                    map = database.get(kUID);
                    arrayList.addAll(map.values());
                    this.databaseStats.STORE_FORWARD_COUNT.incrementStat();
                    continue;
                }
                if (!operation.equals((Object)Operation.DELETE) || !DatabaseSettings.DELETE_VALUE_IF_FURTHEST_NODE.getValue()) continue;
                map = database.get(kUID);
                for (DHTValueEntity dHTValueEntity : map.values()) {
                    database.remove(dHTValueEntity.getPrimaryKey(), dHTValueEntity.getSecondaryKey());
                }
                this.databaseStats.STORE_FORWARD_REMOVALS.incrementStat();
            }
        }
        if (!arrayList.isEmpty()) {
            database2 = null;
            if (dHTMessage instanceof SecurityTokenProvider && (database2 = ((SecurityTokenProvider)((Object)dHTMessage)).getSecurityToken()) == null && StoreSettings.STORE_REQUIRES_SECURITY_TOKEN.getValue()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(contact + " sent us a null SecurityToken"));
                }
                return;
            }
            this.context.store(contact, (SecurityToken)database2, arrayList);
        }
    }

    private boolean containsNodeID(Collection<Contact> collection, KUID kUID) {
        for (Contact contact : collection) {
            if (!kUID.equals(contact.getNodeID())) continue;
            return true;
        }
        return false;
    }

    private Operation getOperation(Contact contact, Contact contact2, KUID kUID) {
        KUID kUID2;
        KUID kUID3;
        int n = KademliaSettings.REPLICATION_PARAMETER.getValue();
        RouteTable routeTable = this.context.getRouteTable();
        List list = CollectionUtils.toList(routeTable.select(kUID, n, RouteTable.SelectMode.ALL));
        Contact contact3 = (Contact)list.get(0);
        Contact contact4 = (Contact)list.get(list.size() - 1);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)MessageFormat.format("node: {0}, existing: {1}, close nodes: {2}", contact, contact2, list));
        }
        if (this.context.isLocalNode(contact3) || contact.equals(contact3) && list.size() > 1 && this.context.isLocalNode((Contact)list.get(1))) {
            KUID kUID4;
            KUID kUID5 = contact.getNodeID();
            if (kUID5.equals(kUID4 = contact4.getNodeID()) || kUID5.isNearerTo(kUID, kUID4)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Node " + contact + " is now close enough to a value and we are responsible for xfer"));
                }
                return Operation.FORWARD;
            }
        } else if (list.size() >= n && this.context.isLocalNode(contact4) && (contact2 == null || contact2.isDead()) && (kUID3 = contact.getNodeID()).isNearerTo(kUID, kUID2 = contact4.getNodeID())) {
            return Operation.DELETE;
        }
        return Operation.NOTHING;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        NOTHING,
        FORWARD,
        DELETE;

    }
}

