/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.util.ArrayUtils;

public class DHTValueImpl
implements DHTValue {
    private static final long serialVersionUID = -7381830963268622187L;
    private static final byte[] EMPTY = new byte[0];
    private final DHTValueType valueType;
    private final Version version;
    private final byte[] value;
    private final int hashCode;

    public DHTValueImpl(DHTValueType dHTValueType, Version version, byte[] byArray) {
        this.valueType = dHTValueType;
        this.version = version;
        if (byArray == null || byArray.length == 0) {
            byArray = EMPTY;
        }
        this.value = byArray;
        this.hashCode = Arrays.hashCode(byArray);
    }

    public DHTValueType getValueType() {
        return this.valueType;
    }

    public Version getVersion() {
        return this.version;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.value, 0, this.value.length);
    }

    public byte[] getValue() {
        byte[] byArray = new byte[this.value.length];
        System.arraycopy(this.value, 0, byArray, 0, this.value.length);
        return byArray;
    }

    public int size() {
        return this.value.length;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DHTValue)) {
            return false;
        }
        DHTValue dHTValue = (DHTValue)object;
        return this.valueType.equals(dHTValue.getValueType()) && this.version.equals(dHTValue.getVersion()) && Arrays.equals(this.value, dHTValue.getValue());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DHTValueType: ").append(this.getValueType()).append("\n");
        stringBuilder.append("Version: ").append(this.getVersion()).append("\n");
        stringBuilder.append("Value: ");
        if (this.size() == 0) {
            stringBuilder.append("This is an empty value (REMOVE operation)");
        } else {
            try {
                if (this.valueType.equals(DHTValueType.TEXT) || this.valueType.equals(DHTValueType.TEST)) {
                    stringBuilder.append(new String(this.getValue(), "UTF-8")).append("\n");
                } else {
                    stringBuilder.append(ArrayUtils.toHexString(this.getValue())).append("\n");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return stringBuilder.toString();
    }
}

