/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.db.impl.DatabaseImpl;
import org.limewire.mojito.settings.DatabaseSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTValueEntityBag
implements Serializable {
    private static final long serialVersionUID = -439172537233232473L;
    private static final float SMOOTHING_FACTOR = DatabaseSettings.VALUE_REQUEST_LOAD_SMOOTHING_FACTOR.getValue();
    private static final int LOAD_NULLING_DELAY = DatabaseSettings.VALUE_REQUEST_LOAD_NULLING_DELAY.getValue();
    private final DatabaseImpl database;
    private final KUID primaryKey;
    private final Map<KUID, DHTValueEntity> values = new HashMap<KUID, DHTValueEntity>();
    private transient float requestLoad = 0.0f;
    private transient long lastRequestTime;

    DHTValueEntityBag(DatabaseImpl databaseImpl, KUID kUID) {
        this.database = databaseImpl;
        this.primaryKey = kUID;
    }

    public Database getDatabase() {
        return this.database;
    }

    public KUID getPrimaryKey() {
        return this.primaryKey;
    }

    public float getRequestLoad(boolean bl) {
        if (bl) {
            this.incrementRequestLoad();
        }
        return this.requestLoad;
    }

    public float incrementRequestLoad() {
        long l = System.currentTimeMillis();
        if (this.lastRequestTime == 0L) {
            this.lastRequestTime = l;
            this.requestLoad = 0.0f;
            return this.requestLoad;
        }
        float f = Math.max((float)(l - this.lastRequestTime) / 1000.0f, 0.01f);
        if (f <= 0.0f || f > (float)LOAD_NULLING_DELAY) {
            this.lastRequestTime = l;
            this.requestLoad = 0.0f;
            return this.requestLoad;
        }
        this.requestLoad += SMOOTHING_FACTOR * (1.0f / f - this.requestLoad);
        this.lastRequestTime = l;
        return this.requestLoad;
    }

    public boolean add(DHTValueEntity dHTValueEntity) {
        if (dHTValueEntity == null) {
            throw new NullPointerException("DHTValueEntity is null");
        }
        if (!this.primaryKey.equals(dHTValueEntity.getPrimaryKey())) {
            throw new IllegalArgumentException();
        }
        this.values.put(dHTValueEntity.getSecondaryKey(), dHTValueEntity);
        return true;
    }

    public DHTValueEntity get(KUID kUID) {
        return this.values.get(kUID);
    }

    public DHTValueEntity remove(KUID kUID) {
        return this.values.remove(kUID);
    }

    public boolean contains(KUID kUID) {
        return this.values.containsKey(kUID);
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int hashCode() {
        return this.primaryKey.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DHTValueEntityBag)) {
            return false;
        }
        return this.primaryKey.equals(((DHTValueEntityBag)object).primaryKey);
    }

    public Map<KUID, DHTValueEntity> getValues(boolean bl) {
        if (bl) {
            return Collections.unmodifiableMap(new HashMap<KUID, DHTValueEntity>(this.values));
        }
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bag: ").append(this.getPrimaryKey()).append("\n");
        stringBuilder.append("Load: ").append(this.getRequestLoad(false)).append("\n");
        stringBuilder.append("Values:").append("\n");
        for (DHTValueEntity dHTValueEntity : this.values.values()) {
            stringBuilder.append(dHTValueEntity).append("\n");
        }
        return stringBuilder.toString();
    }
}

