/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.FutureEvent;
import org.limewire.mojito.Context;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.db.StorableModelManager;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.DatabaseSettings;
import org.limewire.mojito.statistics.DatabaseStatisticContainer;

public class StorablePublisher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(StorablePublisher.class);
    private final Context context;
    private final DatabaseStatisticContainer databaseStats;
    private ScheduledFuture future;
    private final PublishTask publishTask = new PublishTask();

    public StorablePublisher(Context context) {
        this.context = context;
        this.databaseStats = context.getDatabaseStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        PublishTask publishTask = this.publishTask;
        synchronized (publishTask) {
            if (this.future == null) {
                long l;
                long l2 = l = DatabaseSettings.STORABLE_PUBLISHER_PERIOD.getValue();
                this.future = this.context.getDHTExecutorService().scheduleWithFixedDelay(this, l2, l, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        PublishTask publishTask = this.publishTask;
        synchronized (publishTask) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
                this.publishTask.stop();
            }
        }
    }

    public void run() {
        if (this.context.isBootstrapped() && !this.context.isBootstrapping()) {
            if (this.publishTask.isDone()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(this.context.getName() + " begins with publishing"));
                }
                this.publishTask.start();
            }
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(this.context.getName() + " is not bootstrapped"));
            }
            this.publishTask.stop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StoreResultHandler
    extends DHTFutureAdapter<StoreResult> {
        private final Storable storable;

        private StoreResultHandler(Storable storable) {
            this.storable = storable;
        }

        @Override
        protected void operationComplete(FutureEvent<StoreResult> futureEvent) {
            FutureEvent.Type type = futureEvent.getType();
            if (type == FutureEvent.Type.SUCCESS) {
                this.handleSuccess((StoreResult)futureEvent.getResult());
            } else if (!StorablePublisher.this.publishTask.next() || type == FutureEvent.Type.CANCELLED) {
                StorablePublisher.this.publishTask.stop();
            }
        }

        private void handleSuccess(final StoreResult storeResult) {
            if (LOG.isInfoEnabled()) {
                Collection<? extends Contact> collection = storeResult.getLocations();
                if (!collection.isEmpty()) {
                    LOG.info((Object)storeResult);
                } else {
                    LOG.info((Object)("Failed to store " + storeResult.getValues()));
                }
            }
            this.storable.handleStoreResult(storeResult);
            StorablePublisher.this.context.getDHTExecutorService().execute(new Runnable(){

                public void run() {
                    StorablePublisher.this.context.getStorableModelManager().handleStoreResult(StoreResultHandler.this.storable, storeResult);
                }
            });
            if (!StorablePublisher.this.publishTask.next()) {
                StorablePublisher.this.publishTask.stop();
            }
        }
    }

    private class PublishTask {
        private Iterator<Storable> values = null;
        private DHTFuture<StoreResult> future = null;

        private PublishTask() {
        }

        public synchronized void stop() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            this.values = null;
        }

        public synchronized boolean isDone() {
            return this.values == null || !this.values.hasNext();
        }

        public synchronized void start() {
            assert (this.isDone());
            StorableModelManager storableModelManager = StorablePublisher.this.context.getStorableModelManager();
            Collection<Storable> collection = storableModelManager.getStorables();
            if (collection == null) {
                collection = Collections.emptyList();
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(StorablePublisher.this.context.getName() + " has " + collection.size() + " DHTValues to process"));
            }
            this.values = collection.iterator();
            this.next();
        }

        private synchronized boolean next() {
            if (this.isDone()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(StorablePublisher.this.context.getName() + " is done with publishing"));
                }
                return false;
            }
            while (this.values.hasNext()) {
                Storable storable = this.values.next();
                if (!this.publish(storable)) continue;
                return true;
            }
            return false;
        }

        private boolean publish(Storable storable) {
            ((StorablePublisher)StorablePublisher.this).databaseStats.REPUBLISHED_VALUES.incrementStat();
            this.future = StorablePublisher.this.context.store(DHTValueEntity.createFromStorable(StorablePublisher.this.context, storable));
            this.future.addFutureListener(new StoreResultHandler(storable));
            return true;
        }
    }
}

