/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.result.StoreResult;

public class Storable {
    private final KUID primaryKey;
    private final DHTValue value;
    private long publishTime;
    private int locationCount;

    public Storable(KUID kUID, DHTValue dHTValue) {
        this.primaryKey = kUID;
        this.value = dHTValue;
    }

    public KUID getPrimaryKey() {
        return this.primaryKey;
    }

    public DHTValue getValue() {
        return this.value;
    }

    public synchronized long getPublishTime() {
        return this.publishTime;
    }

    public synchronized void setPublishTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("PublishTime is negative: " + l);
        }
        this.publishTime = l;
    }

    public synchronized int getLocationCount() {
        return this.locationCount;
    }

    public synchronized void setLocationCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("LocationCount is negative: " + n);
        }
        this.locationCount = n;
    }

    protected synchronized void handleStoreResult(StoreResult storeResult) {
        this.setPublishTime(System.currentTimeMillis());
        this.setLocationCount(storeResult.getLocations().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Storable storable = this;
        synchronized (storable) {
            stringBuilder.append("PrimaryKey=").append(this.getPrimaryKey()).append("\n");
            stringBuilder.append("Value=").append(this.getValue()).append("\n");
            stringBuilder.append("PublishTime=").append(this.getPublishTime()).append("\n");
            stringBuilder.append("LocationCount=").append(this.getLocationCount()).append("\n");
        }
        return stringBuilder.toString();
    }
}

