/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db;

import java.io.Serializable;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.routing.Contact;

public class DHTValueEntity
implements Serializable {
    private static final long serialVersionUID = 2007158043378144871L;
    private final Contact creator;
    private final Contact sender;
    private final KUID primaryKey;
    private final KUID secondaryKey;
    private final DHTValue value;
    private final long creationTime = System.currentTimeMillis();
    private final boolean local;
    private final int hashCode;

    public static DHTValueEntity createFromStorable(MojitoDHT mojitoDHT, Storable storable) {
        return new DHTValueEntity(mojitoDHT.getLocalNode(), mojitoDHT.getLocalNode(), storable.getPrimaryKey(), storable.getValue(), true);
    }

    public static DHTValueEntity createFromValue(MojitoDHT mojitoDHT, KUID kUID, DHTValue dHTValue) {
        return new DHTValueEntity(mojitoDHT.getLocalNode(), mojitoDHT.getLocalNode(), kUID, dHTValue, true);
    }

    public static DHTValueEntity createFromRemote(Contact contact, Contact contact2, KUID kUID, DHTValue dHTValue) {
        return new DHTValueEntity(contact, contact2, kUID, dHTValue, false);
    }

    DHTValueEntity(Contact contact, Contact contact2, KUID kUID, DHTValue dHTValue, boolean bl) {
        this.creator = contact;
        this.sender = contact2;
        this.primaryKey = kUID;
        this.secondaryKey = contact.getNodeID();
        this.value = dHTValue;
        this.local = bl;
        this.hashCode = 17 * kUID.hashCode() + this.secondaryKey.hashCode();
    }

    public Contact getCreator() {
        return this.creator;
    }

    public Contact getSender() {
        return this.sender;
    }

    public KUID getPrimaryKey() {
        return this.primaryKey;
    }

    public KUID getSecondaryKey() {
        return this.secondaryKey;
    }

    public DHTValue getValue() {
        return this.value;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public boolean isDirect() {
        return this.creator.equals(this.sender);
    }

    public boolean isLocalValue() {
        return this.local;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DHTValueEntity)) {
            return false;
        }
        DHTValueEntity dHTValueEntity = (DHTValueEntity)object;
        return this.primaryKey.equals(dHTValueEntity.getPrimaryKey()) && this.secondaryKey.equals(dHTValueEntity.getSecondaryKey());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Creator: ").append(this.getCreator()).append("\n");
        stringBuilder.append("Sender: ").append(this.getSender()).append("\n");
        stringBuilder.append("Primary Key: ").append(this.getPrimaryKey()).append("\n");
        stringBuilder.append("Secondary Key: ").append(this.getSecondaryKey()).append("\n");
        stringBuilder.append("Creation time: ").append(this.getCreationTime()).append("\n");
        stringBuilder.append("---\n").append(this.getValue()).append("\n");
        return stringBuilder.toString();
    }
}

