/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.security.KeyPair;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueFactoryManager;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.db.EvictorManager;
import org.limewire.mojito.db.StorableModelManager;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.io.MessageDispatcherFactory;
import org.limewire.mojito.messages.MessageFactory;
import org.limewire.mojito.result.BootstrapResult;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.statistics.DHTStats;
import org.limewire.mojito.util.HostFilter;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MojitoDHT
extends Closeable {
    public String getName();

    public Vendor getVendor();

    public Version getVersion();

    public void setKeyPair(KeyPair var1);

    public KeyPair getKeyPair();

    public DHTStats getDHTStats();

    public KUID getLocalNodeID();

    public Contact getLocalNode();

    public boolean isFirewalled();

    public boolean isBound();

    public void bind(int var1) throws IOException;

    public void bind(InetAddress var1, int var2) throws IOException;

    public void bind(SocketAddress var1) throws IOException;

    public boolean isRunning();

    public void start();

    public void stop();

    @Override
    public void close();

    public boolean isBootstrapping();

    public boolean isBootstrapped();

    public BigInteger size();

    public void setExternalPort(int var1);

    public int getExternalPort();

    public SocketAddress getContactAddress();

    public SocketAddress getLocalAddress();

    public void setMessageFactory(MessageFactory var1);

    public MessageDispatcher setMessageDispatcher(MessageDispatcherFactory var1);

    public void setRouteTable(RouteTable var1);

    public RouteTable getRouteTable();

    public void setHostFilter(HostFilter var1);

    public HostFilter getHostFilter();

    public void setDatabase(Database var1);

    public Database getDatabase();

    public DHTValueFactoryManager getDHTValueFactoryManager();

    public StorableModelManager getStorableModelManager();

    public EvictorManager getEvictorManager();

    public DHTFuture<BootstrapResult> bootstrap(Contact var1);

    public DHTFuture<BootstrapResult> bootstrap(SocketAddress var1);

    public DHTFuture<PingResult> findActiveContact();

    public DHTFuture<PingResult> ping(SocketAddress var1);

    public DHTFuture<FindValueResult> get(EntityKey var1);

    public DHTFuture<StoreResult> put(KUID var1, DHTValue var2);

    public DHTFuture<StoreResult> remove(KUID var1);

    public void setDHTExecutorService(DHTExecutorService var1);

    public DHTExecutorService getDHTExecutorService();

    public void setSecurityTokenProvider(SecurityToken.TokenProvider var1);

    public void setMACCalculatorRepositoryManager(MACCalculatorRepositoryManager var1);
}

