/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public interface IpPort {
    public static final Comparator<IpPort> IP_COMPARATOR = new IpComparator();
    public static final Comparator<IpPort> COMPARATOR = new IpPortComparator();
    public static final List<IpPort> EMPTY_LIST = Collections.emptyList();
    public static final Set<IpPort> EMPTY_SET = Collections.emptySet();

    public InetAddress getInetAddress();

    public int getPort();

    public String getAddress();

    public InetSocketAddress getInetSocketAddress();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IpPortComparator
    implements Comparator<IpPort> {
        @Override
        public int compare(IpPort ipPort, IpPort ipPort2) {
            if (ipPort == ipPort2) {
                return 0;
            }
            if (ipPort.getPort() != ipPort2.getPort()) {
                return ipPort.getPort() - ipPort2.getPort();
            }
            return IP_COMPARATOR.compare(ipPort, ipPort2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IpComparator
    implements Comparator<IpPort> {
        @Override
        public int compare(IpPort ipPort, IpPort ipPort2) {
            byte[] byArray;
            if (ipPort == ipPort2) {
                return 0;
            }
            byte[] byArray2 = ipPort.getInetAddress().getAddress();
            if (byArray2[0] == (byArray = ipPort2.getInetAddress().getAddress())[0]) {
                if (byArray2[1] == byArray[1]) {
                    if (byArray2[2] == byArray[2]) {
                        if (byArray2[3] == byArray[3]) {
                            return 0;
                        }
                        return byArray2[3] - byArray[3];
                    }
                    return byArray2[2] - byArray[2];
                }
                return byArray2[1] - byArray[1];
            }
            return byArray2[0] - byArray[0];
        }
    }
}

