/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.HeaderInterceptor;

public class BasicHeaderProcessor {
    private List<HeaderInterceptor> headerInterceptors = null;

    public void addInterceptor(HeaderInterceptor headerInterceptor) {
        if (headerInterceptor == null) {
            throw new IllegalArgumentException();
        }
        if (this.headerInterceptors == null) {
            this.headerInterceptors = new ArrayList<HeaderInterceptor>();
        }
        this.headerInterceptors.add(headerInterceptor);
    }

    public void removeInterceptor(HeaderInterceptor headerInterceptor) {
        if (headerInterceptor == null) {
            throw new IllegalArgumentException();
        }
        if (this.headerInterceptors != null) {
            this.headerInterceptors.remove(headerInterceptor);
        }
    }

    public void clearInterceptors() {
        this.headerInterceptors = null;
    }

    public HeaderInterceptor[] getInterceptors() {
        return this.headerInterceptors != null ? this.headerInterceptors.toArray(new HeaderInterceptor[0]) : new HeaderInterceptor[]{};
    }

    public void process(HttpMessage httpMessage, HttpContext httpContext) throws IOException, HttpException {
        if (this.headerInterceptors != null) {
            Header[] headerArray;
            for (Header header : headerArray = httpMessage.getAllHeaders()) {
                for (HeaderInterceptor headerInterceptor : this.headerInterceptors) {
                    headerInterceptor.process(header, httpContext);
                }
            }
        }
    }
}

