/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.limewire.security.AbstractSecurityToken;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;
import org.limewire.util.ByteOrder;

public final class AddressSecurityToken
extends AbstractSecurityToken {
    public static final int MIN_QK_SIZE_IN_BYTES = 4;
    public static final int MAX_QK_SIZE_IN_BYTES = 16;
    private final int _hashCode = this.genHashCode(this.getBytes());

    public AddressSecurityToken(SocketAddress socketAddress, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        this(((InetSocketAddress)socketAddress).getAddress(), ((InetSocketAddress)socketAddress).getPort(), mACCalculatorRepositoryManager);
    }

    public AddressSecurityToken(InetAddress inetAddress, int n, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        this(new AddressTokenData(inetAddress, n), mACCalculatorRepositoryManager);
    }

    public AddressSecurityToken(AddressTokenData addressTokenData, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        super(addressTokenData, mACCalculatorRepositoryManager);
    }

    public AddressSecurityToken(byte[] byArray, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) throws InvalidSecurityTokenException {
        super((byte[])byArray.clone(), mACCalculatorRepositoryManager);
    }

    private int genHashCode(byte[] byArray) {
        int n = 0x5A5A5A5A;
        for (int i = byArray.length - 1; i >= 0; --i) {
            n ^= 0xFF & byArray[i];
            n *= (n << 1) + 1;
            n = n >>> 27 | n << 5;
        }
        return n;
    }

    protected byte[] getFromMAC(byte[] byArray, SecurityToken.TokenData tokenData) {
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] != 28) continue;
            byArray[i] = -6;
        }
        return byArray;
    }

    public boolean isFor(SocketAddress socketAddress) {
        InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        int n = ((InetSocketAddress)socketAddress).getPort();
        return this.isFor(inetAddress, n);
    }

    public boolean isFor(InetAddress inetAddress, int n) {
        return this.isFor(new AddressTokenData(inetAddress, n));
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return "{AddressSecurityToken: " + new BigInteger(1, this.getBytes()).toString(16) + "}";
    }

    public static boolean isValidSecurityTokenBytes(byte[] byArray) {
        return byArray != null && byArray.length >= 4 && byArray.length <= 16;
    }

    protected boolean isValidBytes(byte[] byArray) {
        return AddressSecurityToken.isValidSecurityTokenBytes(byArray);
    }

    public static class AddressTokenData
    implements SecurityToken.TokenData {
        protected final byte[] data;

        public AddressTokenData(SocketAddress socketAddress) {
            this(((InetSocketAddress)socketAddress).getAddress(), ((InetSocketAddress)socketAddress).getPort());
        }

        public AddressTokenData(InetAddress inetAddress, int n) {
            byte[] byArray = inetAddress.getAddress();
            int n2 = 0;
            for (int i = 3; i >= 0; --i) {
                n2 ^= byArray[i] << (i << 3);
            }
            this.data = new byte[8];
            ByteOrder.int2beb((int)n, (byte[])this.data, (int)0);
            ByteOrder.int2beb((int)n2, (byte[])this.data, (int)4);
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

