/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.timeout;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.timeout.Timeoutable;

public class TimeoutController {
    private static final Log LOG = LogFactory.getLog(TimeoutController.class);
    private final PriorityQueue<Timeout> items = new PriorityQueue(20);
    private final List<Timeout> timedout = new ArrayList<Timeout>(100);

    public synchronized int getNumPendingTimeouts() {
        return this.items.size();
    }

    public synchronized void addTimeout(Timeoutable timeoutable, long l, long l2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding timeoutable: " + timeoutable + ", now: " + l + ", timeout: " + l2));
        }
        this.items.offer(new Timeout(timeoutable, l, l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimeouts(long l) {
        Timeout timeout;
        TimeoutController timeoutController = this;
        synchronized (timeoutController) {
            while (!this.items.isEmpty()) {
                timeout = this.items.peek();
                if (timeout != null && l >= timeout.expireTime) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Timing out: " + timeout + ", expired: " + timeout.expireTime + ", now: " + l + ", length: " + timeout.timeoutLength));
                    }
                } else {
                    if (timeout == null || !LOG.isDebugEnabled()) break;
                    LOG.debug((Object)("Breaking -- next timeout at: " + timeout.expireTime + ", now: " + l));
                    break;
                }
                this.timedout.add(timeout);
                this.items.poll();
            }
        }
        for (int i = 0; i < this.timedout.size(); ++i) {
            timeout = this.timedout.get(i);
            timeout.timeoutable.notifyTimeout(l, timeout.expireTime, timeout.timeoutLength);
        }
        this.timedout.clear();
    }

    public synchronized long getNextExpireTime() {
        if (this.items.isEmpty()) {
            return -1L;
        }
        return this.items.peek().expireTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Timeout
    implements Comparable<Timeout> {
        private final long expireTime;
        private final Timeoutable timeoutable;
        private final long timeoutLength;

        Timeout(Timeoutable timeoutable, long l, long l2) {
            this.expireTime = l2 > 0L && Long.MAX_VALUE - l2 < l ? Long.MAX_VALUE : l + l2;
            this.timeoutLength = l2;
            this.timeoutable = timeoutable;
        }

        @Override
        public int compareTo(Timeout timeout) {
            return this.expireTime > timeout.expireTime ? 1 : (this.expireTime < timeout.expireTime ? -1 : 0);
        }

        public String toString() {
            return "TimeoutWrapper for: " + this.timeoutable;
        }
    }
}

