/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.statemachine;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.limewire.nio.statemachine.ReadState;
import org.limewire.util.BufferUtils;

public class ReadSkipState
extends ReadState {
    private final AtomicLong leftToRead;

    public ReadSkipState(long l) {
        this(new AtomicLong(l));
    }

    public ReadSkipState(AtomicLong atomicLong) {
        this.leftToRead = atomicLong;
    }

    protected boolean processRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        this.leftToRead.set(BufferUtils.delete((ByteBuffer)byteBuffer, (long)this.leftToRead.get()));
        int n = 0;
        while (this.leftToRead.get() > 0L && (n = readableByteChannel.read(byteBuffer)) > 0) {
            this.leftToRead.set(BufferUtils.delete((ByteBuffer)byteBuffer, (long)this.leftToRead.get()));
        }
        if (this.leftToRead.get() > 0L && n == -1) {
            throw new IOException("EOF");
        }
        return this.leftToRead.get() > 0L;
    }

    public long getAmountProcessed() {
        return -1L;
    }
}

