/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.NIOSocket;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.ssl.SSLReadWriteChannel;
import org.limewire.nio.ssl.SSLUtils;

public class TLSNIOSocket
extends NIOSocket {
    private volatile SSLReadWriteChannel tlsLayer;
    private volatile InterestReadableByteChannel baseReader;
    private volatile InterestWritableByteChannel baseWriter;

    public TLSNIOSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
    }

    public TLSNIOSocket(InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
    }

    public TLSNIOSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        super(string, n, inetAddress, n2);
    }

    public TLSNIOSocket(String string, int n) throws UnknownHostException, IOException {
        super(string, n);
    }

    public TLSNIOSocket() throws IOException {
    }

    TLSNIOSocket(Socket socket) {
        super(socket);
    }

    public boolean connect(SocketAddress socketAddress, int n, ConnectObserver connectObserver) {
        return super.connect(socketAddress, n, new TLSConnectInitializer(socketAddress, connectObserver));
    }

    protected InterestReadableByteChannel getBaseReadChannel() {
        if (this.baseReader == null) {
            this.tlsLayer.setReadChannel(super.getBaseReadChannel());
            this.baseReader = this.tlsLayer;
        }
        return this.baseReader;
    }

    protected InterestWritableByteChannel getBaseWriteChannel() {
        if (this.baseWriter == null) {
            this.tlsLayer.setWriteChannel(super.getBaseWriteChannel());
            this.baseWriter = this.tlsLayer;
        }
        return this.baseWriter;
    }

    protected void initIncomingSocket() {
        super.initIncomingSocket();
        this.tlsLayer = new SSLReadWriteChannel(SSLUtils.getTLSContext(), SSLUtils.getExecutor(), NIODispatcher.instance().getBufferCache(), NIODispatcher.instance().getScheduledExecutorService());
        this.tlsLayer.initialize(this.getRemoteSocketAddress(), SSLUtils.getTLSCipherSuites(), false, false);
    }

    protected void initOutgoingSocket() throws IOException {
        super.initOutgoingSocket();
        this.tlsLayer = new SSLReadWriteChannel(SSLUtils.getTLSContext(), SSLUtils.getExecutor(), NIODispatcher.instance().getBufferCache(), NIODispatcher.instance().getScheduledExecutorService());
    }

    protected void shutdownObservers() {
        if (this.tlsLayer != null) {
            this.tlsLayer.shutdown();
        }
        super.shutdownObservers();
    }

    SSLReadWriteChannel getSSLChannel() {
        return this.tlsLayer;
    }

    public long getReadTimeout() {
        if (this.tlsLayer != null && this.tlsLayer.isHandshaking()) {
            try {
                return this.getSoTimeout();
            }
            catch (SocketException socketException) {
                return 0L;
            }
        }
        return super.getReadTimeout();
    }

    private class TLSConnectInitializer
    implements ConnectObserver {
        private final ConnectObserver delegate;
        private final SocketAddress addr;

        public TLSConnectInitializer(SocketAddress socketAddress, ConnectObserver connectObserver) {
            this.delegate = connectObserver;
            this.addr = socketAddress;
        }

        public void handleConnect(Socket socket) throws IOException {
            TLSNIOSocket.this.tlsLayer.initialize(this.addr, SSLUtils.getTLSCipherSuites(), true, false);
            this.delegate.handleConnect(socket);
        }

        public void handleIOException(IOException iOException) {
            this.delegate.handleIOException(iOException);
        }

        public void shutdown() {
            this.delegate.shutdown();
        }
    }
}

