/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;

public abstract class AbstractBufferChannelWriter
implements ChannelWriter {
    protected InterestWritableByteChannel channel;
    protected ByteBuffer buffer;
    protected volatile boolean shutdown;

    public AbstractBufferChannelWriter(int n) {
        this.buffer = ByteBuffer.allocate(n);
    }

    public synchronized InterestWritableByteChannel getWriteChannel() {
        return this.channel;
    }

    public synchronized void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this.channel = interestWritableByteChannel;
        interestWritableByteChannel.interestWrite(this, true);
    }

    public synchronized void put(byte[] byArray) throws IOException {
        if (this.shutdown) {
            throw new EOFException();
        }
        this.buffer.put(byArray);
        if (this.channel != null) {
            this.channel.interestWrite(this, true);
        }
    }

    public synchronized boolean handleWrite() throws IOException {
        if (this.channel == null) {
            throw new IllegalStateException("writing with no source.");
        }
        this.buffer.flip();
        while (this.buffer.hasRemaining() && this.channel.write(this.buffer) > 0) {
        }
        boolean bl = this.buffer.hasRemaining();
        if (bl) {
            this.buffer.compact();
            return true;
        }
        this.buffer.clear();
        this.channel.interestWrite(this, false);
        return false;
    }

    public void handleIOException(IOException iOException) {
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

