/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.InterestScatteringByteChannel;

class SocketInterestReadAdapter
implements InterestScatteringByteChannel {
    private static final IOException OOM = new IOException("Out Of Memory");
    private SocketChannel channel;

    SocketInterestReadAdapter(SocketChannel socketChannel) {
        this.channel = socketChannel;
    }

    public void interestRead(boolean bl) {
        NIODispatcher.instance().interestRead(this.channel, bl);
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.channel.read(byteBuffer);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            throw OOM;
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    ReadableByteChannel getChannel() {
        return this.channel;
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.channel.read(byteBufferArray, n, n2);
    }

    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.channel.read(byteBufferArray);
    }

    public String toString() {
        return "SocketInterestReadAdapter: " + this.channel;
    }
}

