/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.limewire.nio.ByteBufferCache;
import org.limewire.service.ErrorService;

public class CircularByteBuffer {
    private static final DevNull DEV_NULL = new DevNull();
    private final ByteBufferCache cache;
    private final int capacity;
    private ByteBuffer in;
    private ByteBuffer out;
    private ByteOrder order = ByteOrder.BIG_ENDIAN;
    private boolean lastOut = true;

    public CircularByteBuffer(int n, ByteBufferCache byteBufferCache) {
        this.cache = byteBufferCache;
        this.capacity = n;
    }

    private void initBuffers() {
        if (this.in == null) {
            assert (this.out == null);
            this.in = this.cache.getHeap(this.capacity);
            this.out = this.in.asReadOnlyBuffer();
        } else assert (this.out != null);
    }

    public final int remainingIn() {
        int n;
        if (this.in == null) {
            return this.capacity;
        }
        int n2 = this.in.position();
        if (n2 > (n = this.out.position())) {
            return this.in.capacity() - n2 + n;
        }
        if (n2 < n) {
            return n - n2;
        }
        return this.lastOut ? this.in.capacity() : 0;
    }

    public final int remainingOut() {
        return this.capacity() - this.remainingIn();
    }

    public void put(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() > this.remainingIn()) {
            throw new BufferOverflowException();
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        this.lastOut = false;
        this.initBuffers();
        if (byteBuffer.remaining() > this.in.remaining()) {
            int n = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + this.in.remaining());
            this.in.put(byteBuffer);
            this.in.rewind();
            byteBuffer.limit(n);
        }
        this.in.put(byteBuffer);
    }

    public void put(CircularByteBuffer circularByteBuffer) {
        if (circularByteBuffer.remainingOut() > this.remainingIn()) {
            throw new BufferOverflowException();
        }
        this.initBuffers();
        if (this.in.remaining() < circularByteBuffer.remainingOut()) {
            circularByteBuffer.out.limit(this.in.remaining());
            this.in.put(circularByteBuffer.out);
            this.in.rewind();
            circularByteBuffer.out.limit(circularByteBuffer.out.capacity());
        }
        this.in.put(circularByteBuffer.out);
        this.lastOut = false;
    }

    public byte get() {
        if (this.remainingOut() < 1) {
            throw new BufferUnderflowException();
        }
        if (!this.out.hasRemaining()) {
            this.out.rewind();
        }
        byte by = this.out.get();
        this.releaseIfEmpty();
        this.lastOut = true;
        return by;
    }

    public void get(byte[] byArray) {
        this.get(byArray, 0, byArray.length);
    }

    public void get(byte[] byArray, int n, int n2) {
        if (this.remainingOut() < n2) {
            throw new BufferUnderflowException();
        }
        if (n2 <= 0) {
            return;
        }
        this.lastOut = true;
        if (this.out.remaining() < n2) {
            int n3 = this.out.remaining();
            this.out.get(byArray, n, n3);
            n += n3;
            n2 -= n3;
            this.out.rewind();
        }
        this.out.get(byArray, n, n2);
        this.releaseIfEmpty();
    }

    public void get(ByteBuffer byteBuffer) {
        if (this.remainingOut() < byteBuffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (byteBuffer.remaining() <= 0) {
            return;
        }
        this.lastOut = true;
        if (this.out.remaining() < byteBuffer.remaining()) {
            byteBuffer.put(this.out);
            this.out.rewind();
        }
        this.out.limit(this.out.position() + byteBuffer.remaining());
        byteBuffer.put(this.out);
        this.out.limit(this.out.capacity());
        this.releaseIfEmpty();
    }

    private void releaseIfEmpty() {
        if (this.in != null && this.out != null && this.out.position() == this.in.position()) {
            this.cache.release(this.in);
            this.in = null;
            this.out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(WritableByteChannel writableByteChannel, int n) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; this.remainingOut() > 0 && n2 < n; n2 += n3) {
            if (!this.out.hasRemaining()) {
                this.out.rewind();
            }
            if (this.in.position() > this.out.position()) {
                if (n == Integer.MAX_VALUE) {
                    this.out.limit(this.in.position());
                } else {
                    this.out.limit(Math.min(this.in.position(), n - n2 + this.out.position()));
                }
            }
            try {
                n3 = writableByteChannel.write(this.out);
            }
            finally {
                if (n3 > 0) {
                    this.lastOut = true;
                }
            }
            this.out.limit(this.out.capacity());
            if (n3 == 0) break;
        }
        this.releaseIfEmpty();
        return n2;
    }

    public int write(WritableByteChannel writableByteChannel) throws IOException {
        return this.write(writableByteChannel, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ReadableByteChannel readableByteChannel) throws IOException {
        int n = 0;
        int n2 = 0;
        while (this.remainingIn() > 0) {
            this.initBuffers();
            if (!this.in.hasRemaining()) {
                this.in.rewind();
            }
            if (this.out.position() > this.in.position()) {
                this.in.limit(this.out.position());
            }
            try {
                n2 = readableByteChannel.read(this.in);
            }
            finally {
                if (n2 > 0) {
                    this.lastOut = false;
                }
            }
            this.in.limit(this.in.capacity());
            if (n2 == 0) break;
            if (n2 == -1) {
                if (n == 0) {
                    throw new IOException();
                }
                return n;
            }
            n += n2;
        }
        return n;
    }

    public int size() {
        return this.remainingOut();
    }

    public int capacity() {
        return this.capacity;
    }

    public String toString() {
        return "circular buffer in:" + this.in + " out:" + this.out;
    }

    public void order(ByteOrder byteOrder) {
        this.order = byteOrder;
    }

    public int getInt() throws BufferUnderflowException {
        if (this.remainingOut() < 4) {
            throw new BufferUnderflowException();
        }
        if (this.order == ByteOrder.BIG_ENDIAN) {
            return this.getU() << 24 | this.getU() << 16 | this.getU() << 8 | this.getU();
        }
        return this.getU() | this.getU() << 8 | this.getU() << 16 | this.getU() << 24;
    }

    private int getU() {
        return this.get() & 0xFF;
    }

    public void discard(int n) {
        if (this.remainingOut() < n) {
            throw new BufferUnderflowException();
        }
        try {
            this.write(DEV_NULL, n);
        }
        catch (IOException iOException) {
            ErrorService.error((Throwable)iOException);
        }
    }

    private static class DevNull
    implements WritableByteChannel {
        private DevNull() {
        }

        public int write(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.remaining();
            byteBuffer.position(byteBuffer.limit());
            return n;
        }

        public void close() throws IOException {
        }

        public boolean isOpen() {
            return true;
        }
    }
}

